/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.immutables.value.Value;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.oauth2.ErrorResponse;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.ImmutableOAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.OAuth2AuthenticatorConfig;
import org.projectnessie.client.auth.oauth2.OAuth2Exception;
import org.projectnessie.client.auth.oauth2.OAuth2Utils;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

@Value.Immutable
abstract class OAuth2ClientConfig
implements OAuth2AuthenticatorConfig {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    OAuth2ClientConfig() {
    }

    static Builder builder() {
        return ImmutableOAuth2ClientConfig.builder();
    }

    @Value.Default
    Duration getMinDefaultAccessTokenLifespan() {
        return Duration.ofSeconds(10L);
    }

    @Value.Default
    Duration getMinRefreshSafetyWindow() {
        return Duration.ofSeconds(1L);
    }

    @Value.Default
    Duration getMinPreemptiveTokenRefreshIdleTimeout() {
        return Duration.ofSeconds(1L);
    }

    @Value.Default
    Duration getMinAuthorizationCodeFlowTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Value.Default
    Duration getMinDeviceCodeFlowTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Value.Default
    Duration getMinDeviceCodeFlowPollInterval() {
        return Duration.ofSeconds(5L);
    }

    @Value.Default
    public boolean ignoreDeviceCodeFlowServerPollInterval() {
        return false;
    }

    @Value.Default
    Supplier<Instant> getClock() {
        return Clock.systemUTC()::instant;
    }

    @Value.Lazy
    JsonNode getOpenIdProviderMetadata() {
        URI issuerUrl = this.getIssuerUrl().orElseThrow(IllegalStateException::new);
        return OAuth2Utils.fetchOpenIdProviderMetadata(this.getHttpClient(), issuerUrl);
    }

    @Value.Lazy
    URI getResolvedTokenEndpoint() {
        if (this.getTokenEndpoint().isPresent()) {
            return this.getTokenEndpoint().get();
        }
        JsonNode json = this.getOpenIdProviderMetadata();
        if (json.has("token_endpoint")) {
            return URI.create(json.get("token_endpoint").asText());
        }
        throw new IllegalStateException("OpenID provider metadata does not contain a token endpoint");
    }

    @Value.Lazy
    URI getResolvedAuthEndpoint() {
        if (this.getAuthEndpoint().isPresent()) {
            return this.getAuthEndpoint().get();
        }
        JsonNode json = this.getOpenIdProviderMetadata();
        if (json.has("authorization_endpoint")) {
            return URI.create(json.get("authorization_endpoint").asText());
        }
        throw new IllegalStateException("OpenID provider metadata does not contain an authorization endpoint");
    }

    @Value.Lazy
    URI getResolvedDeviceAuthEndpoint() {
        if (this.getDeviceAuthEndpoint().isPresent()) {
            return this.getDeviceAuthEndpoint().get();
        }
        JsonNode json = this.getOpenIdProviderMetadata();
        if (json.has("device_authorization_endpoint")) {
            return URI.create(json.get("device_authorization_endpoint").asText());
        }
        throw new IllegalStateException("OpenID provider metadata does not contain a device authorization endpoint");
    }

    @Value.Lazy
    Optional<HttpAuthentication> getBasicAuthentication() {
        return this.getClientSecret().map(s -> BasicAuthenticationProvider.create(this.getClientId(), s.getString()));
    }

    @Value.Lazy
    HttpClient getHttpClient() {
        return HttpClient.builder().setObjectMapper(this.getObjectMapper()).setSslContext(this.getSslContext().orElse(null)).setDisableCompression(true).addResponseFilter(this::checkErrorResponse).build();
    }

    private void checkErrorResponse(ResponseContext responseContext) {
        try {
            Status status = responseContext.getResponseCode();
            if (status.getCode() >= 400) {
                if (!responseContext.isJsonCompatibleResponse()) {
                    throw OAuth2ClientConfig.genericError(status);
                }
                InputStream is = responseContext.getErrorStream();
                if (is != null) {
                    try {
                        ErrorResponse errorResponse = (ErrorResponse)this.getObjectMapper().readValue(is, ErrorResponse.class);
                        throw new OAuth2Exception(status, errorResponse);
                    }
                    catch (IOException ignored) {
                        throw OAuth2ClientConfig.genericError(status);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientException(e);
        }
    }

    private static HttpClientException genericError(Status status) {
        return new HttpClientException("OAuth2 server replied with HTTP status code: " + status.getCode());
    }

    private static void check(List<String> violations, String paramKey, boolean cond, String msg, Object ... args) {
        if (!cond) {
            if (args.length == 0) {
                violations.add(msg + " (" + paramKey + ")");
            } else {
                violations.add(String.format(msg, args) + " (" + paramKey + ")");
            }
        }
    }

    @Value.Check
    void check() {
        GrantType grantType;
        ArrayList<String> violations = new ArrayList<String>();
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.client-id", !this.getClientId().isEmpty(), "client ID must not be empty", new Object[0]);
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.issuer-url / nessie.authentication.oauth2.token-endpoint", this.getIssuerUrl().isPresent() || this.getTokenEndpoint().isPresent(), "either issuer URL or token endpoint must be set", new Object[0]);
        if (this.getTokenEndpoint().isPresent()) {
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.token-endpoint", this.getTokenEndpoint().get().getQuery() == null, "Token endpoint must not have a query part", new Object[0]);
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.token-endpoint", this.getTokenEndpoint().get().getFragment() == null, "Token endpoint must not have a fragment part", new Object[0]);
        }
        if (this.getAuthEndpoint().isPresent()) {
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.auth-endpoint", this.getAuthEndpoint().get().getQuery() == null, "Authorization endpoint must not have a query part", new Object[0]);
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.auth-endpoint", this.getAuthEndpoint().get().getFragment() == null, "Authorization endpoint must not have a fragment part", new Object[0]);
        }
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.grant-type", (grantType = this.getGrantType()) == GrantType.CLIENT_CREDENTIALS || grantType == GrantType.PASSWORD || grantType == GrantType.AUTHORIZATION_CODE || grantType == GrantType.DEVICE_CODE, "grant type must be either '%s', '%s', '%s' or '%s'", "client_credentials", "password", "authorization_code", "device_code");
        if (grantType == GrantType.PASSWORD) {
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.username", this.getUsername().isPresent() && !this.getUsername().get().isEmpty(), "username must be set if grant type is '%s'", "password");
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.password", this.getPassword().isPresent() && this.getPassword().get().isNotEmpty(), "password must be set if grant type is '%s'", "password");
        }
        if (grantType == GrantType.AUTHORIZATION_CODE) {
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.issuer-url / nessie.authentication.oauth2.auth-endpoint", this.getIssuerUrl().isPresent() || this.getAuthEndpoint().isPresent(), "either issuer URL or authorization endpoint must be set if grant type is '%s'", "authorization_code");
            if (this.getAuthorizationCodeFlowWebServerPort().isPresent()) {
                OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.auth-code-flow.web-port", this.getAuthorizationCodeFlowWebServerPort().getAsInt() >= 0 && this.getAuthorizationCodeFlowWebServerPort().getAsInt() <= 65535, "authorization code flow: web server port must be between 0 and 65535 (inclusive)", new Object[0]);
            }
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.auth-code-flow.timeout", this.getAuthorizationCodeFlowTimeout().compareTo(this.getMinAuthorizationCodeFlowTimeout()) >= 0, "authorization code flow: timeout must be greater than or equal to %s", this.getMinAuthorizationCodeFlowTimeout());
        }
        if (grantType == GrantType.DEVICE_CODE) {
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.issuer-url / nessie.authentication.oauth2.auth-endpoint", this.getIssuerUrl().isPresent() || this.getDeviceAuthEndpoint().isPresent(), "either issuer URL or device authorization endpoint must be set if grant type is '%s'", "device_code");
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.device-code-flow.poll-interval", this.getDeviceCodeFlowPollInterval().compareTo(this.getMinDeviceCodeFlowPollInterval()) >= 0, "device code flow: poll interval must be greater than or equal to %s", this.getMinDeviceCodeFlowPollInterval());
            OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.device-code-flow.timeout", this.getDeviceCodeFlowTimeout().compareTo(this.getMinDeviceCodeFlowTimeout()) >= 0, "device code flow: timeout must be greater than or equal to %s", this.getMinDeviceCodeFlowTimeout());
        }
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.default-access-token-lifespan", this.getDefaultAccessTokenLifespan().compareTo(this.getMinDefaultAccessTokenLifespan()) >= 0, "default token lifespan must be greater than or equal to %s", this.getMinDefaultAccessTokenLifespan());
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.refresh-safety-window", this.getRefreshSafetyWindow().compareTo(this.getMinRefreshSafetyWindow()) >= 0, "refresh safety window must be greater than or equal to %s", this.getMinRefreshSafetyWindow());
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.refresh-safety-window/nessie.authentication.oauth2.default-access-token-lifespan", this.getRefreshSafetyWindow().compareTo(this.getDefaultAccessTokenLifespan()) < 0, "refresh safety window must be less than the default token lifespan", new Object[0]);
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.preemptive-token-refresh-idle-timeout", this.getPreemptiveTokenRefreshIdleTimeout().compareTo(this.getMinPreemptiveTokenRefreshIdleTimeout()) >= 0, "preemptive token refresh idle timeout must be greater than or equal to %s", this.getMinPreemptiveTokenRefreshIdleTimeout());
        OAuth2ClientConfig.check(violations, "nessie.authentication.oauth2.background-thread-idle-timeout", this.getBackgroundThreadIdleTimeout().compareTo(Duration.ZERO) > 0, "background thread idle timeout must be greater than zero", new Object[0]);
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException("OAuth2 authentication is missing some parameters and could not be initialized: " + String.join((CharSequence)", ", violations));
        }
    }

    static void applyConfigOption(Function<String, String> config, String option, Function<String, OAuth2AuthenticatorConfig.Builder> setter) {
        OAuth2ClientConfig.applyConfigOption(config, option, setter, Function.identity());
    }

    static <T> void applyConfigOption(Function<String, String> config, String option, Function<T, OAuth2AuthenticatorConfig.Builder> setter, Function<String, T> converter) {
        String s = config.apply(option);
        if (s != null) {
            setter.apply(converter.apply(s));
        }
    }

    static interface Builder
    extends OAuth2AuthenticatorConfig.Builder {
        @Override
        @CanIgnoreReturnValue
        public Builder from(OAuth2AuthenticatorConfig var1);

        @Override
        public Builder issuerUrl(URI var1);

        @Override
        public Builder tokenEndpoint(URI var1);

        @Override
        public Builder authEndpoint(URI var1);

        @Override
        public Builder deviceAuthEndpoint(URI var1);

        @Override
        public Builder grantType(GrantType var1);

        @Override
        public Builder clientId(String var1);

        @Override
        public Builder clientSecret(Secret var1);

        @Override
        default public Builder clientSecret(String clientSecret) {
            return this.clientSecret(new Secret(clientSecret));
        }

        @Override
        public Builder username(String var1);

        @Override
        public Builder password(Secret var1);

        @Override
        default public Builder password(String password) {
            return this.password(new Secret(password));
        }

        @Override
        public Builder scope(String var1);

        @Override
        public Builder tokenExchangeEnabled(boolean var1);

        @Override
        public Builder defaultAccessTokenLifespan(Duration var1);

        @Override
        public Builder defaultRefreshTokenLifespan(Duration var1);

        @Override
        public Builder refreshSafetyWindow(Duration var1);

        @Override
        public Builder preemptiveTokenRefreshIdleTimeout(Duration var1);

        @Override
        public Builder backgroundThreadIdleTimeout(Duration var1);

        @Override
        public Builder authorizationCodeFlowTimeout(Duration var1);

        @Override
        public Builder authorizationCodeFlowWebServerPort(int var1);

        @Override
        public Builder deviceCodeFlowTimeout(Duration var1);

        @Override
        public Builder deviceCodeFlowPollInterval(Duration var1);

        @Override
        public Builder sslContext(SSLContext var1);

        @Override
        public Builder objectMapper(ObjectMapper var1);

        @Override
        public Builder executor(ScheduledExecutorService var1);

        @CanIgnoreReturnValue
        public Builder minDefaultAccessTokenLifespan(Duration var1);

        @CanIgnoreReturnValue
        public Builder minRefreshSafetyWindow(Duration var1);

        @CanIgnoreReturnValue
        public Builder minPreemptiveTokenRefreshIdleTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder minAuthorizationCodeFlowTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder minDeviceCodeFlowTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder minDeviceCodeFlowPollInterval(Duration var1);

        @CanIgnoreReturnValue
        public Builder ignoreDeviceCodeFlowServerPollInterval(boolean var1);

        @CanIgnoreReturnValue
        public Builder clock(Supplier<Instant> var1);

        @Override
        public OAuth2ClientConfig build();
    }
}

