/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.ImmutableRefreshTokensRequest;
import org.projectnessie.client.auth.oauth2.MustFetchNewTokensException;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientUtils;
import org.projectnessie.client.auth.oauth2.RefreshTokensResponse;
import org.projectnessie.client.auth.oauth2.Token;
import org.projectnessie.client.auth.oauth2.Tokens;

class RefreshTokensFlow
extends AbstractFlow {
    RefreshTokensFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens currentTokens) {
        Objects.requireNonNull(currentTokens);
        Objects.requireNonNull(currentTokens.getRefreshToken());
        if (this.isAboutToExpire(currentTokens.getRefreshToken())) {
            throw new MustFetchNewTokensException("Refresh token is about to expire");
        }
        ImmutableRefreshTokensRequest request = ImmutableRefreshTokensRequest.builder().refreshToken(currentTokens.getRefreshToken().getPayload()).scope(this.config.getScope().orElse(null)).build();
        return this.invokeTokenEndpoint(request, RefreshTokensResponse.class);
    }

    private boolean isAboutToExpire(Token token) {
        Instant now = this.config.getClock().get();
        Instant expirationTime = OAuth2ClientUtils.tokenExpirationTime(now, token, this.config.getDefaultRefreshTokenLifespan());
        return expirationTime.isBefore(now.plus(this.config.getRefreshSafetyWindow()));
    }
}

