/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.ImmutablePasswordTokensRequest;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.PasswordTokensResponse;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.auth.oauth2.Tokens;

class ResourceOwnerPasswordFlow
extends AbstractFlow {
    ResourceOwnerPasswordFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens ignored) {
        String username = this.config.getUsername().orElseThrow(() -> new IllegalStateException("Username is required"));
        String password = this.config.getPassword().map(Secret::getString).orElseThrow(() -> new IllegalStateException("Password is required"));
        ImmutablePasswordTokensRequest request = ImmutablePasswordTokensRequest.builder().username(username).password(password).scope(this.config.getScope().orElse(null)).build();
        return this.invokeTokenEndpoint(request, PasswordTokensResponse.class);
    }
}

