/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpHeaders;
import org.projectnessie.client.http.impl.RequestContextImpl;
import org.projectnessie.client.http.impl.apache.ApacheHttpClient;
import org.projectnessie.client.http.impl.apache.ApacheResponseContext;

final class ApacheRequest
extends BaseHttpRequest {
    private final ApacheHttpClient client;

    ApacheRequest(ApacheHttpClient apacheHttpClient, URI baseUri) {
        super(apacheHttpClient.config, baseUri);
        this.client = apacheHttpClient;
    }

    @Override
    public HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        URI uri = this.uriBuilder.build();
        HttpUriRequestBase request = new HttpUriRequestBase(method.name(), uri);
        RequestContextImpl context = new RequestContextImpl(this.headers, uri, method, body);
        boolean doesOutput = this.prepareRequest(context);
        this.config.getRequestFilters().forEach(a -> a.filter(context));
        for (HttpHeaders.HttpHeader header : this.headers.allHeaders()) {
            for (String value : header.getValues()) {
                request.addHeader(header.getName(), (Object)value);
            }
        }
        request.addHeader("Accept", (Object)this.accept);
        if (doesOutput) {
            HttpEntity entity = HttpEntities.create(os -> this.writeToOutputStream(context, (OutputStream)os), (ContentType)ContentType.parse((CharSequence)this.contentsType));
            request.setEntity(entity);
        }
        CloseableHttpResponse response = null;
        try {
            response = this.client.client.execute((ClassicHttpRequest)request);
            ApacheResponseContext responseContext = new ApacheResponseContext(response, uri);
            List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
            if (callbacks != null) {
                callbacks.forEach(callback -> callback.accept(responseContext, null));
            }
            this.config.getResponseFilters().forEach(responseFilter -> responseFilter.filter(responseContext));
            if (response.getCode() >= 400) {
                throw new HttpClientException(String.format("%s request to %s failed with HTTP/%d", new Object[]{method, uri, response.getCode()}));
            }
            response = null;
            HttpResponse httpResponse = new HttpResponse(responseContext, this.config.getMapper());
            return httpResponse;
        }
        catch (ConnectTimeoutException e) {
            throw new HttpClientException(String.format("Timeout connecting to '%s' after %ds", uri, this.config.getConnectionTimeoutMillis() / 1000), e);
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

