/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

final class ApacheResponseContext
implements ResponseContext {
    private final CloseableHttpResponse response;
    private URI uri;

    ApacheResponseContext(CloseableHttpResponse response, URI uri) {
        this.response = response;
        this.uri = uri;
    }

    @Override
    public Status getResponseCode() {
        return Status.fromCode(this.response.getCode());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.reader();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.reader();
    }

    @Override
    public boolean isJsonCompatibleResponse() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(59);
        if (i > 0) {
            contentType = contentType.substring(0, i);
        }
        return contentType.endsWith("/json") || contentType.endsWith("+json");
    }

    @Override
    public String getContentType() {
        return this.headerValue("Content-Type");
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    private String headerValue(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    private InputStream reader() throws IOException {
        return new RequestClosingInputStream(this.response);
    }

    private static final class RequestClosingInputStream
    extends InputStream {
        private final InputStream in;
        private final CloseableHttpResponse response;

        RequestClosingInputStream(CloseableHttpResponse response) throws IOException {
            this.response = response;
            try {
                this.in = response.getEntity().getContent();
            }
            catch (IOException e) {
                response.close();
                throw e;
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                this.response.close();
            }
        }
    }
}

