/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.time.Instant;
import org.projectnessie.client.auth.oauth2.DeviceCodeRequest;
import org.projectnessie.client.auth.oauth2.DeviceCodeResponse;
import org.projectnessie.client.auth.oauth2.Flow;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientUtils;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.Token;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;
import org.projectnessie.client.auth.oauth2.TokensResponseBase;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;

abstract class AbstractFlow
implements Flow {
    final OAuth2ClientConfig config;

    AbstractFlow(OAuth2ClientConfig config) {
        this.config = config;
    }

    <REQ extends TokensRequestBase, RESP extends TokensResponseBase> Tokens invokeTokenEndpoint(TokensRequestBase.Builder<REQ> request, Class<? extends RESP> responseClass) {
        this.config.getScope().ifPresent(request::scope);
        this.maybeAddClientId(request);
        return ((TokensResponseBase)this.invokeEndpoint(this.config.getResolvedTokenEndpoint(), request.build(), responseClass)).asTokens(this.config.getClock());
    }

    DeviceCodeResponse invokeDeviceAuthEndpoint() {
        DeviceCodeRequest.Builder request = DeviceCodeRequest.builder();
        this.config.getScope().ifPresent(request::scope);
        this.maybeAddClientId(request);
        return this.invokeEndpoint(this.config.getResolvedDeviceAuthEndpoint(), request.build(), DeviceCodeResponse.class);
    }

    private void maybeAddClientId(Object request) {
        if (this.config.isPublicClient() && request instanceof PublicClientRequest.Builder) {
            ((PublicClientRequest.Builder)request).clientId(this.config.getClientId());
        }
    }

    private <REQ, RESP> RESP invokeEndpoint(URI endpoint, REQ request, Class<? extends RESP> responseClass) {
        HttpRequest req = this.config.getHttpClient().newRequest(endpoint);
        this.config.getBasicAuthentication().ifPresent(req::authentication);
        HttpResponse response = req.postForm(request);
        return response.readEntity(responseClass);
    }

    protected boolean isAboutToExpire(Token token) {
        Instant now = this.config.getClock().get();
        Instant expirationTime = OAuth2ClientUtils.tokenExpirationTime(now, token, this.config.getDefaultRefreshTokenLifespan());
        return expirationTime.isBefore(now.plus(this.config.getRefreshSafetyWindow()));
    }
}

