/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.ImmutableOAuth2AuthenticatorConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.Secret;

@Value.Immutable(lazyhash=true)
public interface OAuth2AuthenticatorConfig {
    public static OAuth2AuthenticatorConfig fromConfigSupplier(Function<String, String> config) {
        Objects.requireNonNull(config, "config must not be null");
        String clientId = config.apply("nessie.authentication.oauth2.client-id");
        String clientSecret = config.apply("nessie.authentication.oauth2.client-secret");
        OAuth2ClientConfig.Builder builder = OAuth2ClientConfig.builder().clientId(clientId != null ? clientId : "").clientSecret(clientSecret != null ? clientSecret : "");
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.issuer-url", builder::issuerUrl, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-endpoint", builder::tokenEndpoint, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.auth-endpoint", builder::authEndpoint, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.device-auth-endpoint", builder::deviceAuthEndpoint, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.grant-type", builder::grantType, GrantType::fromConfigName);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.username", builder::username);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.password", builder::password);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.client-scopes", builder::scope);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange-enabled", builder::tokenExchangeEnabled, Boolean::parseBoolean);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.default-access-token-lifespan", builder::defaultAccessTokenLifespan, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.default-refresh-token-lifespan", builder::defaultRefreshTokenLifespan, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.refresh-safety-window", builder::refreshSafetyWindow, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.preemptive-token-refresh-idle-timeout", builder::preemptiveTokenRefreshIdleTimeout, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.background-thread-idle-timeout", builder::backgroundThreadIdleTimeout, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.auth-code-flow.timeout", builder::authorizationCodeFlowTimeout, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.auth-code-flow.web-port", builder::authorizationCodeFlowWebServerPort, Integer::parseInt);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.device-code-flow.timeout", builder::deviceCodeFlowTimeout, Duration::parse);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.device-code-flow.poll-interval", builder::deviceCodeFlowPollInterval, Duration::parse);
        return builder.build();
    }

    public Optional<URI> getIssuerUrl();

    public Optional<URI> getTokenEndpoint();

    public Optional<URI> getAuthEndpoint();

    public Optional<URI> getDeviceAuthEndpoint();

    @Value.Default
    default public GrantType getGrantType() {
        return GrantType.CLIENT_CREDENTIALS;
    }

    public String getClientId();

    public Optional<Secret> getClientSecret();

    public Optional<String> getUsername();

    public Optional<Secret> getPassword();

    public Optional<String> getScope();

    @Value.Default
    default public boolean getTokenExchangeEnabled() {
        return true;
    }

    @Value.Default
    default public Duration getDefaultAccessTokenLifespan() {
        return Duration.parse("PT1M");
    }

    @Value.Default
    default public Duration getDefaultRefreshTokenLifespan() {
        return Duration.parse("PT30M");
    }

    @Value.Default
    default public Duration getRefreshSafetyWindow() {
        return Duration.parse("PT10S");
    }

    @Value.Default
    default public Duration getPreemptiveTokenRefreshIdleTimeout() {
        return Duration.parse("PT30S");
    }

    @Value.Default
    default public Duration getBackgroundThreadIdleTimeout() {
        return Duration.parse("PT30S");
    }

    @Value.Default
    default public Duration getAuthorizationCodeFlowTimeout() {
        return Duration.parse("PT5M");
    }

    public OptionalInt getAuthorizationCodeFlowWebServerPort();

    @Value.Default
    default public Duration getDeviceCodeFlowTimeout() {
        return Duration.parse("PT5M");
    }

    @Value.Default
    default public Duration getDeviceCodeFlowPollInterval() {
        return Duration.parse("PT5S");
    }

    public Optional<SSLContext> getSslContext();

    @Value.Default
    default public ObjectMapper getObjectMapper() {
        return OAuth2ClientConfig.OBJECT_MAPPER;
    }

    public Optional<ScheduledExecutorService> getExecutor();

    public static Builder builder() {
        return ImmutableOAuth2AuthenticatorConfig.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder from(OAuth2AuthenticatorConfig var1);

        @CanIgnoreReturnValue
        public Builder issuerUrl(URI var1);

        @CanIgnoreReturnValue
        public Builder tokenEndpoint(URI var1);

        @CanIgnoreReturnValue
        public Builder authEndpoint(URI var1);

        @CanIgnoreReturnValue
        public Builder deviceAuthEndpoint(URI var1);

        @CanIgnoreReturnValue
        public Builder grantType(GrantType var1);

        @CanIgnoreReturnValue
        public Builder clientId(String var1);

        @CanIgnoreReturnValue
        public Builder clientSecret(Secret var1);

        default public Builder clientSecret(String clientSecret) {
            return this.clientSecret(new Secret(clientSecret));
        }

        @CanIgnoreReturnValue
        public Builder username(String var1);

        @CanIgnoreReturnValue
        public Builder password(Secret var1);

        default public Builder password(String password) {
            return this.password(new Secret(password));
        }

        @CanIgnoreReturnValue
        public Builder scope(String var1);

        @CanIgnoreReturnValue
        public Builder tokenExchangeEnabled(boolean var1);

        @CanIgnoreReturnValue
        public Builder defaultAccessTokenLifespan(Duration var1);

        @CanIgnoreReturnValue
        public Builder defaultRefreshTokenLifespan(Duration var1);

        @CanIgnoreReturnValue
        public Builder refreshSafetyWindow(Duration var1);

        @CanIgnoreReturnValue
        public Builder preemptiveTokenRefreshIdleTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder backgroundThreadIdleTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder authorizationCodeFlowTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder authorizationCodeFlowWebServerPort(int var1);

        @CanIgnoreReturnValue
        public Builder deviceCodeFlowTimeout(Duration var1);

        @CanIgnoreReturnValue
        public Builder deviceCodeFlowPollInterval(Duration var1);

        @CanIgnoreReturnValue
        public Builder sslContext(SSLContext var1);

        @CanIgnoreReturnValue
        public Builder objectMapper(ObjectMapper var1);

        @CanIgnoreReturnValue
        public Builder executor(ScheduledExecutorService var1);

        public OAuth2AuthenticatorConfig build();
    }
}

