/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.Objects;
import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.MustFetchNewTokensException;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.RefreshTokensRequest;
import org.projectnessie.client.auth.oauth2.RefreshTokensResponse;
import org.projectnessie.client.auth.oauth2.Tokens;

class RefreshTokensFlow
extends AbstractFlow {
    RefreshTokensFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens currentTokens) {
        Objects.requireNonNull(currentTokens);
        Objects.requireNonNull(currentTokens.getRefreshToken());
        if (this.isAboutToExpire(currentTokens.getRefreshToken())) {
            throw new MustFetchNewTokensException("Refresh token is about to expire");
        }
        RefreshTokensRequest.Builder request = RefreshTokensRequest.builder().refreshToken(currentTokens.getRefreshToken().getPayload());
        return this.invokeTokenEndpoint(request, RefreshTokensResponse.class);
    }
}

