/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;

public interface NessieHttpClientBuilder
extends NessieClientBuilder {
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withHttp2Upgrade(boolean var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withFollowRedirects(String var1);

    @Deprecated
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withForceUrlConnectionClient(boolean var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withClientName(String var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withResponseFactory(HttpResponseFactory var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder addRequestFilter(RequestFilter var1);

    @CanIgnoreReturnValue
    public NessieHttpClientBuilder addResponseFilter(ResponseFilter var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder fromConfig(Function<String, String> var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withApiCompatibilityCheck(boolean var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withAuthenticationFromConfig(Function<String, String> var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withAuthentication(NessieAuthentication var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withTracing(boolean var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withUri(URI var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withUri(String var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withReadTimeout(int var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withConnectionTimeout(int var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withDisableCompression(boolean var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withSSLContext(SSLContext var1);

    @Override
    @CanIgnoreReturnValue
    public NessieHttpClientBuilder withSSLParameters(SSLParameters var1);

    public static abstract class AbstractNessieHttpClientBuilder
    extends NessieClientBuilder.AbstractNessieClientBuilder
    implements NessieHttpClientBuilder {
        @Override
        public NessieHttpClientBuilder fromConfig(Function<String, String> configuration) {
            String forceUrlConnectionClient;
            super.fromConfig(configuration);
            String s = configuration.apply("nessie.http2-upgrade");
            if (s != null) {
                this.withHttp2Upgrade(Boolean.parseBoolean(s.trim()));
            }
            if ((s = configuration.apply("nessie.http-redirects")) != null) {
                this.withFollowRedirects(s.trim());
            }
            if ((s = configuration.apply(forceUrlConnectionClient = "nessie.force-url-connection-client")) != null) {
                this.withForceUrlConnectionClient(Boolean.parseBoolean(s.trim()));
            }
            if ((s = configuration.apply("nessie.client-builder-name")) != null) {
                this.withClientName(s.trim());
            }
            return this;
        }

        @Override
        public NessieHttpClientBuilder withHttp2Upgrade(boolean http2Upgrade) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withFollowRedirects(String redirects) {
            return this;
        }

        @Override
        @Deprecated
        public NessieHttpClientBuilder withForceUrlConnectionClient(boolean forceUrlConnectionClient) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withClientName(String clientName) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withResponseFactory(HttpResponseFactory responseFactory) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder addRequestFilter(RequestFilter filter) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder addResponseFilter(ResponseFilter filter) {
            return this;
        }

        @Override
        public NessieHttpClientBuilder withAuthenticationFromConfig(Function<String, String> configuration) {
            return (NessieHttpClientBuilder)super.withAuthenticationFromConfig(configuration);
        }

        @Override
        public NessieHttpClientBuilder withUri(String uri) {
            return (NessieHttpClientBuilder)super.withUri(uri);
        }

        @Override
        public NessieHttpClientBuilder withApiCompatibilityCheck(boolean enable) {
            return (NessieHttpClientBuilder)super.withApiCompatibilityCheck(enable);
        }

        @Override
        public NessieHttpClientBuilder withAuthentication(NessieAuthentication authentication) {
            return (NessieHttpClientBuilder)super.withAuthentication(authentication);
        }

        @Override
        public NessieHttpClientBuilder withTracing(boolean tracing) {
            return (NessieHttpClientBuilder)super.withTracing(tracing);
        }

        @Override
        public NessieHttpClientBuilder withUri(URI uri) {
            return (NessieHttpClientBuilder)super.withUri(uri);
        }

        @Override
        public NessieHttpClientBuilder withReadTimeout(int readTimeoutMillis) {
            return (NessieHttpClientBuilder)super.withReadTimeout(readTimeoutMillis);
        }

        @Override
        public NessieHttpClientBuilder withConnectionTimeout(int connectionTimeoutMillis) {
            return (NessieHttpClientBuilder)super.withConnectionTimeout(connectionTimeoutMillis);
        }

        @Override
        public NessieHttpClientBuilder withDisableCompression(boolean disableCompression) {
            return (NessieHttpClientBuilder)super.withDisableCompression(disableCompression);
        }

        @Override
        public NessieHttpClientBuilder withSSLContext(SSLContext sslContext) {
            return (NessieHttpClientBuilder)super.withSSLContext(sslContext);
        }

        @Override
        public NessieHttpClientBuilder withSSLParameters(SSLParameters sslParameters) {
            return (NessieHttpClientBuilder)super.withSSLParameters(sslParameters);
        }
    }
}

