/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.Objects;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.MustFetchNewTokensException;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.auth.oauth2.TokensExchangeRequest;
import org.projectnessie.client.auth.oauth2.TokensExchangeResponse;

class TokenExchangeFlow
extends AbstractFlow {
    static final URI ACCESS_TOKEN_ID = URI.create("urn:ietf:params:oauth:token-type:access_token");

    TokenExchangeFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(Tokens currentTokens) {
        if (!this.config.getTokenExchangeEnabled()) {
            throw new MustFetchNewTokensException("Token exchange is disabled");
        }
        Objects.requireNonNull(currentTokens);
        TokensExchangeRequest.Builder request = TokensExchangeRequest.builder().subjectToken(currentTokens.getAccessToken().getPayload()).subjectTokenType(ACCESS_TOKEN_ID).requestedTokenType(ACCESS_TOKEN_ID);
        Tokens response = this.invokeTokenEndpoint(request, TokensExchangeResponse.class);
        if (this.isAboutToExpire(response.getAccessToken(), this.config.getDefaultAccessTokenLifespan())) {
            throw new MustFetchNewTokensException("Access token is about to expire");
        }
        return response;
    }
}

