/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.builder.BaseOnReferenceBuilder;
import org.projectnessie.client.builder.StreamingUtil;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;

public abstract class BaseGetEntriesBuilder<PARAMS>
extends BaseOnReferenceBuilder<GetEntriesBuilder>
implements GetEntriesBuilder {
    private final BiFunction<PARAMS, String, PARAMS> paramsForPage;
    private String pageToken;
    protected Integer maxRecords;
    protected final List<ContentKey> keys = new ArrayList<ContentKey>();
    protected ContentKey minKey;
    protected ContentKey maxKey;
    protected ContentKey prefixKey;
    protected String filter;
    protected boolean withContent;

    protected BaseGetEntriesBuilder(BiFunction<PARAMS, String, PARAMS> paramsForPage) {
        this.paramsForPage = paramsForPage;
    }

    @Override
    public GetEntriesBuilder maxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    @Override
    public GetEntriesBuilder pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Override
    public GetEntriesBuilder key(ContentKey key) {
        this.keys.add(key);
        return this;
    }

    @Override
    public GetEntriesBuilder keys(Collection<ContentKey> keys) {
        this.keys.addAll(keys);
        return this;
    }

    @Override
    public GetEntriesBuilder minKey(ContentKey minKey) {
        this.minKey = minKey;
        return this;
    }

    @Override
    public GetEntriesBuilder maxKey(ContentKey maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    @Override
    public GetEntriesBuilder prefixKey(ContentKey prefixKey) {
        this.prefixKey = prefixKey;
        return this;
    }

    @Override
    public GetEntriesBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public GetEntriesBuilder withContent(boolean withContent) {
        this.withContent = withContent;
        return this;
    }

    protected abstract PARAMS params();

    protected abstract EntriesResponse get(PARAMS var1) throws NessieNotFoundException;

    @Override
    public EntriesResponse get() throws NessieNotFoundException {
        return this.get(this.paramsForPage.apply(this.params(), this.pageToken));
    }

    @Override
    public Stream<EntriesResponse.Entry> stream() throws NessieNotFoundException {
        PARAMS p = this.params();
        return StreamingUtil.generateStream(EntriesResponse::getEntries, pageToken -> this.get(this.paramsForPage.apply(p, pageToken)));
    }
}

