/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import org.projectnessie.client.auth.oauth2.ErrorResponse;
import org.projectnessie.client.http.HttpClientResponseException;
import org.projectnessie.client.http.Status;

public class OAuth2Exception
extends HttpClientResponseException {
    private final String errorCode;

    OAuth2Exception(Status status, ErrorResponse errorResponse) {
        super(OAuth2Exception.createMessage(status, errorResponse), status);
        this.errorCode = errorResponse.getErrorCode();
    }

    private static String createMessage(Status status, ErrorResponse errorResponse) {
        StringBuilder builder = new StringBuilder().append("OAuth2 server replied with HTTP status code ").append(status.getCode()).append(" and error code \"").append(errorResponse.getErrorCode()).append("\"");
        if (errorResponse.getErrorDescription() != null) {
            builder.append(": ").append(errorResponse.getErrorDescription());
        }
        return builder.toString();
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

