/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableTokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.auth.oauth2.TypedToken;

@Value.Immutable
public interface TokenExchangeConfig {
    public static final List<String> SCOPES_INHERIT = Collections.singletonList("\\inherit\\");
    public static final TokenExchangeConfig DISABLED = TokenExchangeConfig.builder().enabled(false).build();
    public static final String CURRENT_ACCESS_TOKEN = "current_access_token";
    public static final String CURRENT_REFRESH_TOKEN = "current_refresh_token";
    public static final String NO_TOKEN = "no_token";

    public static TokenExchangeConfig fromConfigSupplier(Function<String, String> config) {
        String enabled = config.apply("nessie.authentication.oauth2.token-exchange.enabled");
        if (!Boolean.parseBoolean(enabled)) {
            return DISABLED;
        }
        Builder builder = TokenExchangeConfig.builder().enabled(true);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.client-id", builder::clientId);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.client-secret", builder::clientSecret);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.issuer-url", builder::issuerUrl, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.token-endpoint", builder::tokenEndpoint, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.resource", builder::resource, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.scopes", scope -> Arrays.stream(scope.split(" ")).forEach(builder::addScope));
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.audience", builder::audience);
        String subjectToken = config.apply("nessie.authentication.oauth2.token-exchange.subject-token");
        String actorToken = config.apply("nessie.authentication.oauth2.token-exchange.actor-token");
        Optional<URI> subjectTokenType = Optional.ofNullable(config.apply("nessie.authentication.oauth2.token-exchange.subject-token-type")).map(URI::create);
        Optional<URI> actorTokenType = Optional.ofNullable(config.apply("nessie.authentication.oauth2.token-exchange.actor-token-type")).map(URI::create);
        if (subjectToken == null || subjectToken.equalsIgnoreCase(CURRENT_ACCESS_TOKEN)) {
            builder.subjectTokenProvider((accessToken, refreshToken) -> TypedToken.of(accessToken, subjectTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
        } else if (subjectToken.equalsIgnoreCase(CURRENT_REFRESH_TOKEN)) {
            builder.subjectTokenProvider((accessToken, refreshToken) -> TypedToken.of(refreshToken, subjectTokenType.orElse(TypedToken.URN_REFRESH_TOKEN)));
        } else {
            builder.subjectToken(TypedToken.of(subjectToken, subjectTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
        }
        if (actorToken != null && !actorToken.equalsIgnoreCase(NO_TOKEN)) {
            if (actorToken.equalsIgnoreCase(CURRENT_ACCESS_TOKEN)) {
                builder.actorTokenProvider((accessToken, refreshToken) -> TypedToken.of(accessToken, actorTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
            } else if (actorToken.equalsIgnoreCase(CURRENT_REFRESH_TOKEN)) {
                builder.actorTokenProvider((accessToken, refreshToken) -> refreshToken == null ? null : TypedToken.of(refreshToken, actorTokenType.orElse(TypedToken.URN_REFRESH_TOKEN)));
            } else {
                builder.actorToken(TypedToken.of(actorToken, actorTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
            }
        }
        return builder.build();
    }

    @Value.Default
    default public boolean isEnabled() {
        return false;
    }

    public Optional<String> getClientId();

    public Optional<Secret> getClientSecret();

    public Optional<URI> getIssuerUrl();

    public Optional<URI> getTokenEndpoint();

    @Value.Default
    default public URI getRequestedTokenType() {
        return TypedToken.URN_ACCESS_TOKEN;
    }

    public Optional<URI> getResource();

    public Optional<String> getAudience();

    @Value.Default
    default public List<String> getScopes() {
        return SCOPES_INHERIT;
    }

    @Value.Default
    @Value.Auxiliary
    default public BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
        return (accessToken, refreshToken) -> TypedToken.of(accessToken);
    }

    @Value.Default
    @Value.Auxiliary
    default public BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
        return (accessToken, refreshToken) -> null;
    }

    public static Builder builder() {
        return ImmutableTokenExchangeConfig.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder enabled(boolean var1);

        @CanIgnoreReturnValue
        public Builder clientId(String var1);

        @CanIgnoreReturnValue
        public Builder clientSecret(Secret var1);

        @CanIgnoreReturnValue
        default public Builder clientSecret(String clientSecret) {
            return this.clientSecret(new Secret(clientSecret));
        }

        @CanIgnoreReturnValue
        public Builder issuerUrl(URI var1);

        @CanIgnoreReturnValue
        public Builder tokenEndpoint(URI var1);

        @CanIgnoreReturnValue
        public Builder requestedTokenType(URI var1);

        @CanIgnoreReturnValue
        public Builder resource(URI var1);

        @CanIgnoreReturnValue
        public Builder audience(String var1);

        @CanIgnoreReturnValue
        public Builder addScope(String var1);

        @CanIgnoreReturnValue
        public Builder addScopes(String ... var1);

        @CanIgnoreReturnValue
        public Builder scopes(Iterable<String> var1);

        @CanIgnoreReturnValue
        public Builder subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> var1);

        @CanIgnoreReturnValue
        public Builder actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> var1);

        @CanIgnoreReturnValue
        default public Builder subjectToken(TypedToken token) {
            return this.subjectTokenProvider((accessToken, refreshToken) -> token);
        }

        @CanIgnoreReturnValue
        default public Builder actorToken(TypedToken token) {
            return this.actorTokenProvider((accessToken, refreshToken) -> token);
        }

        public TokenExchangeConfig build();
    }
}

