/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableAccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableRefreshToken;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Tokens;

interface TokenResponseBase {
    default public Tokens asTokens(Supplier<Instant> clock) {
        Instant now = clock.get();
        Integer accessExpiresIn = this.getAccessTokenExpiresInSeconds();
        final ImmutableAccessToken accessToken = ImmutableAccessToken.builder().tokenType(this.getTokenType()).payload(this.getAccessTokenPayload()).expirationTime(accessExpiresIn == null ? null : now.plusSeconds(accessExpiresIn.intValue())).build();
        String refreshTokenPayload = this.getRefreshTokenPayload();
        Integer refreshExpiresIn = this.getRefreshTokenExpiresInSeconds();
        final ImmutableRefreshToken refreshToken = refreshTokenPayload == null ? null : ImmutableRefreshToken.builder().payload(refreshTokenPayload).expirationTime(refreshExpiresIn == null ? null : now.plusSeconds(refreshExpiresIn.intValue())).build();
        return new Tokens(){

            @Override
            public AccessToken getAccessToken() {
                return accessToken;
            }

            @Override
            @Nullable
            public RefreshToken getRefreshToken() {
                return refreshToken;
            }
        };
    }

    @JsonProperty(value="token_type")
    public String getTokenType();

    @JsonProperty(value="access_token")
    public String getAccessTokenPayload();

    @Nullable
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    public Integer getAccessTokenExpiresInSeconds();

    @Nullable
    @JsonProperty(value="refresh_token")
    public String getRefreshTokenPayload();

    @Nullable
    @JsonProperty(value="refresh_expires_in")
    public Integer getRefreshTokenExpiresInSeconds();

    @Nullable
    @JsonProperty(value="scope")
    public String getScope();

    @JsonAnyGetter
    public Map<String, Object> getExtraParameters();
}

