/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.TypedToken;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TokenExchangeConfig", generator="Immutables")
@Immutable
public final class ImmutableTokenExchangeConfig
implements TokenExchangeConfig {
    private final boolean enabled;
    @Nullable
    private final String clientId;
    @Nullable
    private final Secret clientSecret;
    @Nullable
    private final URI issuerUrl;
    @Nullable
    private final URI tokenEndpoint;
    private final URI requestedTokenType;
    @Nullable
    private final URI resource;
    @Nullable
    private final String audience;
    private final List<String> scopes;
    private final BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
    private final BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTokenExchangeConfig(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.issuerUrl = builder.issuerUrl;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.resource = builder.resource;
        this.audience = builder.audience;
        if (builder.enabledIsSet()) {
            this.initShim.enabled(builder.enabled);
        }
        if (builder.requestedTokenType != null) {
            this.initShim.requestedTokenType(builder.requestedTokenType);
        }
        if (builder.scopesIsSet()) {
            this.initShim.scopes(ImmutableTokenExchangeConfig.createUnmodifiableList(true, builder.scopes));
        }
        if (builder.subjectTokenProvider != null) {
            this.initShim.subjectTokenProvider(builder.subjectTokenProvider);
        }
        if (builder.actorTokenProvider != null) {
            this.initShim.actorTokenProvider(builder.actorTokenProvider);
        }
        this.enabled = this.initShim.isEnabled();
        this.requestedTokenType = this.initShim.getRequestedTokenType();
        this.scopes = this.initShim.getScopes();
        this.subjectTokenProvider = this.initShim.getSubjectTokenProvider();
        this.actorTokenProvider = this.initShim.getActorTokenProvider();
        this.initShim = null;
    }

    private ImmutableTokenExchangeConfig(boolean enabled, @Nullable String clientId, @Nullable Secret clientSecret, @Nullable URI issuerUrl, @Nullable URI tokenEndpoint, URI requestedTokenType, @Nullable URI resource, @Nullable String audience, List<String> scopes, BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider, BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
        this.enabled = enabled;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.issuerUrl = issuerUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.requestedTokenType = requestedTokenType;
        this.resource = resource;
        this.audience = audience;
        this.scopes = scopes;
        this.subjectTokenProvider = subjectTokenProvider;
        this.actorTokenProvider = actorTokenProvider;
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return TokenExchangeConfig.super.isEnabled();
    }

    private URI getRequestedTokenTypeInitialize() {
        return TokenExchangeConfig.super.getRequestedTokenType();
    }

    private List<String> getScopesInitialize() {
        return TokenExchangeConfig.super.getScopes();
    }

    private BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProviderInitialize() {
        return TokenExchangeConfig.super.getSubjectTokenProvider();
    }

    private BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProviderInitialize() {
        return TokenExchangeConfig.super.getActorTokenProvider();
    }

    @Override
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.enabled;
    }

    @Override
    public Optional<String> getClientId() {
        return Optional.ofNullable(this.clientId);
    }

    @Override
    public Optional<Secret> getClientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    @Override
    public Optional<URI> getIssuerUrl() {
        return Optional.ofNullable(this.issuerUrl);
    }

    @Override
    public Optional<URI> getTokenEndpoint() {
        return Optional.ofNullable(this.tokenEndpoint);
    }

    @Override
    public URI getRequestedTokenType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestedTokenType() : this.requestedTokenType;
    }

    @Override
    public Optional<URI> getResource() {
        return Optional.ofNullable(this.resource);
    }

    @Override
    public Optional<String> getAudience() {
        return Optional.ofNullable(this.audience);
    }

    @Override
    public List<String> getScopes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getScopes() : this.scopes;
    }

    @Override
    public BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSubjectTokenProvider() : this.subjectTokenProvider;
    }

    @Override
    public BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getActorTokenProvider() : this.actorTokenProvider;
    }

    public final ImmutableTokenExchangeConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(value, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (Objects.equals(this.clientId, newValue)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, newValue, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withClientId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, value, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withClientSecret(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret == newValue) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, newValue, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withClientSecret(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.clientSecret == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, value, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withIssuerUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "issuerUrl");
        if (this.issuerUrl == newValue) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, newValue, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withIssuerUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.issuerUrl == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, value, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withTokenEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "tokenEndpoint");
        if (this.tokenEndpoint == newValue) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, newValue, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withTokenEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.tokenEndpoint == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, value, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withRequestedTokenType(URI value) {
        if (this.requestedTokenType == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "requestedTokenType");
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, newValue, this.resource, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withResource(URI value) {
        URI newValue = Objects.requireNonNull(value, "resource");
        if (this.resource == newValue) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, newValue, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withResource(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.resource == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, value, this.audience, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withAudience(String value) {
        String newValue = Objects.requireNonNull(value, "audience");
        if (Objects.equals(this.audience, newValue)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, newValue, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withAudience(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.audience, value)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, value, this.scopes, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withScopes(String ... elements) {
        List<String> newValue = ImmutableTokenExchangeConfig.createUnmodifiableList(false, ImmutableTokenExchangeConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, newValue, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableTokenExchangeConfig.createUnmodifiableList(false, ImmutableTokenExchangeConfig.createSafeList(elements, true, false));
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, newValue, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withSubjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> value) {
        if (this.subjectTokenProvider == value) {
            return this;
        }
        BiFunction<AccessToken, RefreshToken, TypedToken> newValue = Objects.requireNonNull(value, "subjectTokenProvider");
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, newValue, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withActorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> value) {
        if (this.actorTokenProvider == value) {
            return this;
        }
        BiFunction<AccessToken, RefreshToken, TypedToken> newValue = Objects.requireNonNull(value, "actorTokenProvider");
        return new ImmutableTokenExchangeConfig(this.enabled, this.clientId, this.clientSecret, this.issuerUrl, this.tokenEndpoint, this.requestedTokenType, this.resource, this.audience, this.scopes, this.subjectTokenProvider, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenExchangeConfig && this.equalTo(0, (ImmutableTokenExchangeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokenExchangeConfig another) {
        return this.enabled == another.enabled && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.issuerUrl, another.issuerUrl) && Objects.equals(this.tokenEndpoint, another.tokenEndpoint) && this.requestedTokenType.equals(another.requestedTokenType) && Objects.equals(this.resource, another.resource) && Objects.equals(this.audience, another.audience) && this.scopes.equals(another.scopes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + Objects.hashCode(this.issuerUrl);
        h += (h << 5) + Objects.hashCode(this.tokenEndpoint);
        h += (h << 5) + this.requestedTokenType.hashCode();
        h += (h << 5) + Objects.hashCode(this.resource);
        h += (h << 5) + Objects.hashCode(this.audience);
        h += (h << 5) + this.scopes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TokenExchangeConfig{");
        builder.append("enabled=").append(this.enabled);
        if (this.clientId != null) {
            builder.append(", ");
            builder.append("clientId=").append(this.clientId);
        }
        if (this.clientSecret != null) {
            builder.append(", ");
            builder.append("clientSecret=").append(this.clientSecret);
        }
        if (this.issuerUrl != null) {
            builder.append(", ");
            builder.append("issuerUrl=").append(this.issuerUrl);
        }
        if (this.tokenEndpoint != null) {
            builder.append(", ");
            builder.append("tokenEndpoint=").append(this.tokenEndpoint);
        }
        builder.append(", ");
        builder.append("requestedTokenType=").append(this.requestedTokenType);
        if (this.resource != null) {
            builder.append(", ");
            builder.append("resource=").append(this.resource);
        }
        if (this.audience != null) {
            builder.append(", ");
            builder.append("audience=").append(this.audience);
        }
        builder.append(", ");
        builder.append("scopes=").append(this.scopes);
        return builder.append("}").toString();
    }

    public static ImmutableTokenExchangeConfig copyOf(TokenExchangeConfig instance) {
        if (instance instanceof ImmutableTokenExchangeConfig) {
            return (ImmutableTokenExchangeConfig)instance;
        }
        return ImmutableTokenExchangeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TokenExchangeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TokenExchangeConfig.Builder {
        private static final long OPT_BIT_ENABLED = 1L;
        private static final long OPT_BIT_SCOPES = 2L;
        private long optBits;
        private boolean enabled;
        @Nullable
        private String clientId;
        @Nullable
        private Secret clientSecret;
        @Nullable
        private URI issuerUrl;
        @Nullable
        private URI tokenEndpoint;
        @Nullable
        private URI requestedTokenType;
        @Nullable
        private URI resource;
        @Nullable
        private String audience;
        private List<String> scopes = new ArrayList<String>();
        @Nullable
        private BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
        @Nullable
        private BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenExchangeConfig instance) {
            Optional<String> audienceOptional;
            Optional<URI> tokenEndpointOptional;
            Optional<URI> issuerUrlOptional;
            Optional<Secret> clientSecretOptional;
            Objects.requireNonNull(instance, "instance");
            this.enabled(instance.isEnabled());
            Optional<String> clientIdOptional = instance.getClientId();
            if (clientIdOptional.isPresent()) {
                this.clientId(clientIdOptional);
            }
            if ((clientSecretOptional = instance.getClientSecret()).isPresent()) {
                this.clientSecret(clientSecretOptional);
            }
            if ((issuerUrlOptional = instance.getIssuerUrl()).isPresent()) {
                this.issuerUrl(issuerUrlOptional);
            }
            if ((tokenEndpointOptional = instance.getTokenEndpoint()).isPresent()) {
                this.tokenEndpoint(tokenEndpointOptional);
            }
            this.requestedTokenType(instance.getRequestedTokenType());
            Optional<URI> resourceOptional = instance.getResource();
            if (resourceOptional.isPresent()) {
                this.resource(resourceOptional);
            }
            if ((audienceOptional = instance.getAudience()).isPresent()) {
                this.audience(audienceOptional);
            }
            this.addAllScopes(instance.getScopes());
            this.subjectTokenProvider((BiFunction)instance.getSubjectTokenProvider());
            this.actorTokenProvider((BiFunction)instance.getActorTokenProvider());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(Optional<String> clientId) {
            this.clientId = clientId.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecret(Secret clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<? extends Secret> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder issuerUrl(URI issuerUrl) {
            this.issuerUrl = Objects.requireNonNull(issuerUrl, "issuerUrl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuerUrl(Optional<? extends URI> issuerUrl) {
            this.issuerUrl = issuerUrl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(Optional<? extends URI> tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder requestedTokenType(URI requestedTokenType) {
            this.requestedTokenType = Objects.requireNonNull(requestedTokenType, "requestedTokenType");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder resource(URI resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resource(Optional<? extends URI> resource) {
            this.resource = resource.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder audience(String audience) {
            this.audience = Objects.requireNonNull(audience, "audience");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder audience(Optional<String> audience) {
            this.audience = audience.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider) {
            this.subjectTokenProvider = Objects.requireNonNull(subjectTokenProvider, "subjectTokenProvider");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
            this.actorTokenProvider = Objects.requireNonNull(actorTokenProvider, "actorTokenProvider");
            return this;
        }

        @Override
        public ImmutableTokenExchangeConfig build() {
            return new ImmutableTokenExchangeConfig(this);
        }

        private boolean enabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean scopesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="TokenExchangeConfig", generator="Immutables")
    private final class InitShim {
        private byte enabledBuildStage = 0;
        private boolean enabled;
        private byte requestedTokenTypeBuildStage = 0;
        private URI requestedTokenType;
        private byte scopesBuildStage = 0;
        private List<String> scopes;
        private byte subjectTokenProviderBuildStage = 0;
        private BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
        private byte actorTokenProviderBuildStage = 0;
        private BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.enabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enabledBuildStage == 0) {
                this.enabledBuildStage = (byte)-1;
                this.enabled = ImmutableTokenExchangeConfig.this.isEnabledInitialize();
                this.enabledBuildStage = 1;
            }
            return this.enabled;
        }

        void enabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledBuildStage = 1;
        }

        URI getRequestedTokenType() {
            if (this.requestedTokenTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestedTokenTypeBuildStage == 0) {
                this.requestedTokenTypeBuildStage = (byte)-1;
                this.requestedTokenType = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getRequestedTokenTypeInitialize(), "requestedTokenType");
                this.requestedTokenTypeBuildStage = 1;
            }
            return this.requestedTokenType;
        }

        void requestedTokenType(URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            this.requestedTokenTypeBuildStage = 1;
        }

        List<String> getScopes() {
            if (this.scopesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopesBuildStage == 0) {
                this.scopesBuildStage = (byte)-1;
                this.scopes = ImmutableTokenExchangeConfig.createUnmodifiableList(false, ImmutableTokenExchangeConfig.createSafeList(ImmutableTokenExchangeConfig.this.getScopesInitialize(), true, false));
                this.scopesBuildStage = 1;
            }
            return this.scopes;
        }

        void scopes(List<String> scopes) {
            this.scopes = scopes;
            this.scopesBuildStage = 1;
        }

        BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
            if (this.subjectTokenProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.subjectTokenProviderBuildStage == 0) {
                this.subjectTokenProviderBuildStage = (byte)-1;
                this.subjectTokenProvider = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getSubjectTokenProviderInitialize(), "subjectTokenProvider");
                this.subjectTokenProviderBuildStage = 1;
            }
            return this.subjectTokenProvider;
        }

        void subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider) {
            this.subjectTokenProvider = subjectTokenProvider;
            this.subjectTokenProviderBuildStage = 1;
        }

        BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
            if (this.actorTokenProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actorTokenProviderBuildStage == 0) {
                this.actorTokenProviderBuildStage = (byte)-1;
                this.actorTokenProvider = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getActorTokenProviderInitialize(), "actorTokenProvider");
                this.actorTokenProviderBuildStage = 1;
            }
            return this.actorTokenProvider;
        }

        void actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
            this.actorTokenProvider = actorTokenProvider;
            this.actorTokenProviderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.enabledBuildStage == -1) {
                attributes.add("enabled");
            }
            if (this.requestedTokenTypeBuildStage == -1) {
                attributes.add("requestedTokenType");
            }
            if (this.scopesBuildStage == -1) {
                attributes.add("scopes");
            }
            if (this.subjectTokenProviderBuildStage == -1) {
                attributes.add("subjectTokenProvider");
            }
            if (this.actorTokenProviderBuildStage == -1) {
                attributes.add("actorTokenProvider");
            }
            return "Cannot build TokenExchangeConfig, attribute initializers form cycle " + attributes;
        }
    }
}

