/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Random;
import org.projectnessie.client.auth.oauth2.JwtToken;
import org.projectnessie.client.auth.oauth2.Token;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpResponse;

class OAuth2Utils {
    private static final Random RANDOM = new SecureRandom();
    private static final String[] WELL_KNOWN_PATHS = new String[]{".well-known/openid-configuration", ".well-known/oauth-authorization-server"};

    OAuth2Utils() {
    }

    static String randomAlphaNumString(int length) {
        return RANDOM.ints(48, 123).filter(i -> i <= 57 || i >= 65 && i <= 90 || i >= 97).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static JsonNode fetchOpenIdProviderMetadata(HttpClient httpClient, URI issuerUrl) {
        ArrayList<Exception> failures = null;
        for (String path : WELL_KNOWN_PATHS) {
            try {
                HttpResponse response = httpClient.newRequest(issuerUrl).path(path).get();
                JsonNode data = response.readEntity(JsonNode.class);
                if (!data.has("issuer") || !data.has("authorization_endpoint")) {
                    throw new HttpClientException("Invalid OpenID provider metadata");
                }
                return data;
            }
            catch (Exception e) {
                if (failures == null) {
                    failures = new ArrayList<Exception>(WELL_KNOWN_PATHS.length);
                }
                failures.add(e);
            }
        }
        HttpClientException e = new HttpClientException("Failed to fetch OpenID provider metadata", (Throwable)failures.get(0));
        for (int i = 1; i < failures.size(); ++i) {
            e.addSuppressed((Throwable)failures.get(i));
        }
        throw e;
    }

    static Duration shortestDelay(Instant now, Instant accessExpirationTime, Instant refreshExpirationTime, Duration refreshSafetyWindow, Duration minRefreshDelay) {
        Instant expirationTime = accessExpirationTime.isBefore(refreshExpirationTime) ? accessExpirationTime : refreshExpirationTime;
        Duration delay = Duration.between(now, expirationTime).minus(refreshSafetyWindow);
        if (delay.compareTo(minRefreshDelay) < 0) {
            delay = minRefreshDelay;
        }
        return delay;
    }

    static Instant tokenExpirationTime(Instant now, Token token, Duration defaultLifespan) {
        Instant expirationTime = null;
        if (token != null && (expirationTime = token.getExpirationTime()) == null) {
            try {
                JwtToken jwtToken = JwtToken.parse(token.getPayload());
                expirationTime = jwtToken.getExpirationTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (expirationTime == null) {
            expirationTime = now.plus(defaultLifespan);
        }
        return expirationTime;
    }
}

