/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.TokenExchangeRequest;
import org.projectnessie.client.auth.oauth2.TokenExchangeResponse;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.auth.oauth2.TypedToken;
import org.projectnessie.client.http.HttpAuthentication;

class TokenExchangeFlow
extends AbstractFlow {
    TokenExchangeFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(Tokens currentTokens) {
        Objects.requireNonNull(currentTokens);
        TokenExchangeConfig tokenExchangeConfig = this.config.getTokenExchangeConfig();
        AccessToken accessToken = currentTokens.getAccessToken();
        RefreshToken refreshToken = currentTokens.getRefreshToken();
        TypedToken subjectToken = tokenExchangeConfig.getSubjectTokenProvider().apply(accessToken, refreshToken);
        TypedToken actorToken = tokenExchangeConfig.getActorTokenProvider().apply(accessToken, refreshToken);
        Objects.requireNonNull(subjectToken);
        TokenExchangeRequest.Builder request = TokenExchangeRequest.builder().subjectToken(subjectToken.getPayload()).subjectTokenType(subjectToken.getTokenType()).actorToken(actorToken == null ? null : actorToken.getPayload()).actorTokenType(actorToken == null ? null : actorToken.getTokenType()).resource(tokenExchangeConfig.getResource().orElse(null)).audience(tokenExchangeConfig.getAudience().orElse(null)).requestedTokenType(tokenExchangeConfig.getRequestedTokenType());
        return this.invokeTokenEndpoint(request, TokenExchangeResponse.class);
    }

    @Override
    Optional<String> getScope() {
        return this.config.getScopesForTokenExchange().stream().reduce((a, b) -> a + " " + b);
    }

    @Override
    URI getResolvedTokenEndpoint() {
        return this.config.getResolvedTokenEndpointForTokenExchange();
    }

    @Override
    String getClientId() {
        return this.config.getClientIdForTokenExchange();
    }

    @Override
    boolean isPublicClient() {
        return this.config.isPublicClientForTokenExchange();
    }

    @Override
    Optional<HttpAuthentication> getBasicAuthentication() {
        return this.config.getBasicAuthenticationForTokenExchange();
    }
}

