/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.Token;
import org.projectnessie.client.auth.oauth2.TypedToken;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TypedToken", generator="Immutables")
@Immutable
public final class ImmutableTypedToken
implements TypedToken {
    private final String payload;
    @Nullable
    private final Instant expirationTime;
    private final URI tokenType;

    private ImmutableTypedToken(String payload, @Nullable Instant expirationTime, URI tokenType) {
        this.payload = payload;
        this.expirationTime = expirationTime;
        this.tokenType = tokenType;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public URI getTokenType() {
        return this.tokenType;
    }

    public final ImmutableTypedToken withPayload(String value) {
        String newValue = Objects.requireNonNull(value, "payload");
        if (this.payload.equals(newValue)) {
            return this;
        }
        return new ImmutableTypedToken(newValue, this.expirationTime, this.tokenType);
    }

    public final ImmutableTypedToken withExpirationTime(@Nullable Instant value) {
        if (this.expirationTime == value) {
            return this;
        }
        return new ImmutableTypedToken(this.payload, value, this.tokenType);
    }

    public final ImmutableTypedToken withTokenType(URI value) {
        if (this.tokenType == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "tokenType");
        return new ImmutableTypedToken(this.payload, this.expirationTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTypedToken && this.equalTo(0, (ImmutableTypedToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableTypedToken another) {
        return this.payload.equals(another.payload) && Objects.equals(this.expirationTime, another.expirationTime) && this.tokenType.equals(another.tokenType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.payload.hashCode();
        h += (h << 5) + Objects.hashCode(this.expirationTime);
        h += (h << 5) + this.tokenType.hashCode();
        return h;
    }

    public String toString() {
        return "TypedToken{payload=" + this.payload + ", expirationTime=" + this.expirationTime + ", tokenType=" + this.tokenType + "}";
    }

    public static ImmutableTypedToken copyOf(TypedToken instance) {
        if (instance instanceof ImmutableTypedToken) {
            return (ImmutableTypedToken)instance;
        }
        return ImmutableTypedToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TypedToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_TOKEN_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String payload;
        @Nullable
        private Instant expirationTime;
        @Nullable
        private URI tokenType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TypedToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Instant expirationTimeValue;
            Token instance;
            long bits = 0L;
            if (object instanceof Token) {
                instance = (Token)object;
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof TypedToken) {
                instance = (TypedToken)object;
                this.tokenType(instance.getTokenType());
                if ((bits & 1L) == 0L) {
                    this.payload(instance.getPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    expirationTimeValue = instance.getExpirationTime();
                    if (expirationTimeValue != null) {
                        this.expirationTime(expirationTimeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expirationTime(@Nullable Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenType(URI tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTypedToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTypedToken(this.payload, this.expirationTime, this.tokenType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenType");
            }
            return "Cannot build TypedToken, some of required attributes are not set " + attributes;
        }
    }
}

