/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.apache.ApacheRequest;

final class ApacheHttpClient
implements HttpClient {
    final HttpRuntimeConfig config;
    final CloseableHttpClient client;

    ApacheHttpClient(HttpRuntimeConfig config) {
        this.config = config;
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        if (config.getSslContext() != null) {
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(config.getSslContext());
            socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        }
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build(), PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.ofMinutes((long)5L));
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(Timeout.ofMilliseconds((long)config.getReadTimeoutMillis())).setTcpNoDelay(true).build();
        connManager.setDefaultSocketConfig(socketConfig);
        connManager.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectionTimeoutMillis())).build());
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(10);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)config.getReadTimeoutMillis())).setRedirectsEnabled(true).setCircularRedirectsAllowed(false).setMaxRedirects(5).setContentCompressionEnabled(!config.isDisableCompression()).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().disableDefaultUserAgent().disableAuthCaching().disableCookieManagement().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(defaultRequestConfig);
        if (config.isDisableCompression()) {
            clientBuilder.disableContentCompression();
        }
        this.client = clientBuilder.build();
    }

    @Override
    public HttpRequest newRequest(URI baseUri) {
        return new ApacheRequest(this, baseUri);
    }

    @Override
    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.config.close();
        }
    }
}

