/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.ImmutableImpersonationConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.Secret;

@Value.Immutable
public interface ImpersonationConfig {
    public static final List<String> SCOPES_INHERIT = Collections.singletonList("\\inherit\\");

    public static ImpersonationConfig fromConfigSupplier(Function<String, String> config) {
        Builder builder = ImpersonationConfig.builder();
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.enabled", builder::enabled, Boolean::parseBoolean);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.client-id", builder::clientId);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.client-secret", builder::clientSecret);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.issuer-url", builder::issuerUrl, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.token-endpoint", builder::tokenEndpoint, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.impersonation.scopes", scope -> Arrays.stream(scope.split(" ")).forEach(builder::addScope));
        return builder.build();
    }

    @Value.Default
    default public boolean isEnabled() {
        return false;
    }

    public Optional<String> getClientId();

    public Optional<Secret> getClientSecret();

    public Optional<URI> getIssuerUrl();

    public Optional<URI> getTokenEndpoint();

    @Value.Default
    default public List<String> getScopes() {
        return SCOPES_INHERIT;
    }

    public static Builder builder() {
        return ImmutableImpersonationConfig.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder enabled(boolean var1);

        @CanIgnoreReturnValue
        public Builder clientId(String var1);

        @CanIgnoreReturnValue
        public Builder clientSecret(Secret var1);

        @CanIgnoreReturnValue
        default public Builder clientSecret(String clientSecret) {
            return this.clientSecret(new Secret(clientSecret));
        }

        @CanIgnoreReturnValue
        public Builder issuerUrl(URI var1);

        @CanIgnoreReturnValue
        public Builder tokenEndpoint(URI var1);

        @CanIgnoreReturnValue
        public Builder addScope(String var1);

        @CanIgnoreReturnValue
        public Builder addScopes(String ... var1);

        @CanIgnoreReturnValue
        public Builder scopes(Iterable<String> var1);

        public ImpersonationConfig build();
    }
}

