/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaResponseContext
implements ResponseContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaResponseContext.class);
    private final HttpResponse<InputStream> response;
    private final InputStream inputStream;

    JavaResponseContext(HttpResponse<InputStream> response) {
        this.response = response;
        try {
            this.inputStream = this.maybeDecompress();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Status getStatus() {
        return Status.fromCode(this.response.statusCode());
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").orElse(null);
    }

    @Override
    public URI getRequestedUri() {
        return this.response.uri();
    }

    @Override
    public void close(Exception error) {
        if (error != null) {
            try {
                LOGGER.debug("Closing unprocessed input stream for {} request to {} delegating to {} ...", new Object[]{this.response.request().method(), this.response.uri(), this.response.body()});
                this.response.body().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private InputStream maybeDecompress() throws IOException {
        InputStream base = this.response.body();
        String contentEncoding = this.response.headers().firstValue("Content-Encoding").orElse("");
        if ("gzip".equals(contentEncoding)) {
            return new GZIPInputStream(base);
        }
        if ("deflate".equals(contentEncoding)) {
            return new InflaterInputStream(base);
        }
        return base;
    }
}

