/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk8;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.net.ssl.HttpsURLConnection;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.jdk8.UrlConnectionResponseContext;

final class UrlConnectionRequest
extends BaseHttpRequest {
    UrlConnectionRequest(HttpRuntimeConfig config, URI baseUri) {
        super(config, baseUri);
    }

    @Override
    protected ResponseContext sendAndReceive(URI uri, HttpClient.Method method, Object body, RequestContext requestContext) throws IOException {
        HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
        con.setReadTimeout(this.config.getReadTimeoutMillis());
        con.setConnectTimeout(this.config.getConnectionTimeoutMillis());
        if (con instanceof HttpsURLConnection) {
            ((HttpsURLConnection)con).setSSLSocketFactory(this.config.getSslContext().getSocketFactory());
        }
        HttpUtils.applyHeaders(this.headers, con);
        con.setRequestMethod(method.name());
        if (requestContext.doesOutput()) {
            con.setDoOutput(true);
            this.writeToOutputStream(requestContext, con.getOutputStream());
        }
        con.connect();
        int code = con.getResponseCode();
        return new UrlConnectionResponseContext(con, uri, Status.fromCode(code));
    }

    @Override
    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    @Override
    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    @Override
    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    @Override
    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }
}

