/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk8;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

final class UrlConnectionResponseContext
implements ResponseContext {
    private final HttpURLConnection connection;
    private final URI uri;
    private final Status status;

    UrlConnectionResponseContext(HttpURLConnection connection, URI uri, Status status) {
        this.connection = connection;
        this.uri = uri;
        this.status = status;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.maybeDecompress(this.connection.getInputStream());
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.maybeDecompress(this.connection.getErrorStream());
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    private InputStream maybeDecompress(InputStream inputStream) throws IOException {
        String contentEncoding = this.connection.getHeaderField("Content-Encoding");
        if ("gzip".equals(contentEncoding)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equals(contentEncoding)) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }
}

