/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Optional;
import org.projectnessie.api.v1.http.HttpConfigApi;
import org.projectnessie.api.v1.http.HttpContentApi;
import org.projectnessie.api.v1.http.HttpDiffApi;
import org.projectnessie.api.v1.http.HttpNamespaceApi;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.rest.v1.NessieApiClient;
import org.projectnessie.client.rest.v1.RestV1ConfigClient;
import org.projectnessie.client.rest.v1.RestV1ContentClient;
import org.projectnessie.client.rest.v1.RestV1DiffClient;
import org.projectnessie.client.rest.v1.RestV1NamespaceClient;
import org.projectnessie.client.rest.v1.RestV1TreeClient;
import org.projectnessie.error.BaseNessieClientServerException;

public final class RestV1Client
extends NessieApiClient {
    private final HttpClient httpClient;

    public RestV1Client(HttpClient client) {
        super(RestV1Client.wrap(HttpConfigApi.class, new RestV1ConfigClient(client)), RestV1Client.wrap(HttpTreeApi.class, new RestV1TreeClient(client)), RestV1Client.wrap(HttpContentApi.class, new RestV1ContentClient(client)), RestV1Client.wrap(HttpDiffApi.class, new RestV1DiffClient(client)), RestV1Client.wrap(HttpNamespaceApi.class, new RestV1NamespaceClient(client)));
        this.httpClient = client;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public Optional<HttpClient> httpClient() {
        return Optional.of(this.httpClient);
    }

    private static <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable cause;
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException && (cause = targetException.getCause()) instanceof BaseNessieClientServerException) {
                    throw cause;
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }
}

