/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.PasswordTokenRequest;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PasswordTokenRequest", generator="Immutables")
@Immutable
final class ImmutablePasswordTokenRequest
implements PasswordTokenRequest {
    @Nullable
    private final String scope;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String username;
    private final String password;

    private ImmutablePasswordTokenRequest(@Nullable String scope, @Nullable String clientId, String username, String password) {
        this.scope = scope;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.grantType = Objects.requireNonNull(PasswordTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public final ImmutablePasswordTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(value, this.clientId, this.username, this.password);
    }

    public final ImmutablePasswordTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, value, this.username, this.password);
    }

    public final ImmutablePasswordTokenRequest withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, this.clientId, newValue, this.password);
    }

    public final ImmutablePasswordTokenRequest withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, this.clientId, this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordTokenRequest && this.equalTo(0, (ImmutablePasswordTokenRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "PasswordTokenRequest{scope=" + this.scope + ", clientId=" + this.clientId + ", grantType=" + (Object)((Object)this.grantType) + ", username=" + this.username + ", password=" + this.password + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePasswordTokenRequest fromJson(Json json) {
        Builder builder = ImmutablePasswordTokenRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        return builder.build();
    }

    public static ImmutablePasswordTokenRequest copyOf(PasswordTokenRequest instance) {
        if (instance instanceof ImmutablePasswordTokenRequest) {
            return (ImmutablePasswordTokenRequest)instance;
        }
        return ImmutablePasswordTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PasswordTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements PasswordTokenRequest.Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        @Nullable
        private String clientId;
        @Nullable
        private String username;
        @Nullable
        private String password;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PasswordTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof PasswordTokenRequest) {
                instance = (PasswordTokenRequest)object;
                this.password(instance.getPassword());
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                this.username(instance.getUsername());
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="username")
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutablePasswordTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePasswordTokenRequest(this.scope, this.clientId, this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build PasswordTokenRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PasswordTokenRequest", generator="Immutables")
    static final class Json
    implements PasswordTokenRequest {
        @Nullable
        String scope;
        @Nullable
        String clientId;
        @Nullable
        String username;
        @Nullable
        String password;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPassword() {
            throw new UnsupportedOperationException();
        }
    }
}

