/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.Objects;
import org.projectnessie.client.http.ExecutableHttpRequest;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequestWrapper;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.impl.HttpHeaders;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.UriBuilder;

public abstract class HttpRequest
implements ExecutableHttpRequest<HttpClientException, RuntimeException> {
    protected final HttpRuntimeConfig config;
    protected final UriBuilder uriBuilder;
    protected final HttpHeaders headers = new HttpHeaders();
    protected String contentsType = "application/json; charset=utf-8";
    protected String accept = "application/json; charset=utf-8";
    protected HttpAuthentication auth;
    protected boolean bypassFilters;

    protected HttpRequest(HttpRuntimeConfig config, URI baseUri) {
        Objects.requireNonNull(baseUri, "Base URI cannot be null");
        HttpUtils.checkArgument(HttpUtils.isHttpUri(baseUri), "Base URI must be a valid http or https address: %s", baseUri);
        this.uriBuilder = new UriBuilder(baseUri);
        this.config = config;
        int clientSpec = config.getClientSpec();
        if (clientSpec > 0) {
            this.headers.put("Nessie-Client-Spec", Integer.toString(clientSpec));
        }
    }

    public HttpRequest authentication(HttpAuthentication auth) {
        this.auth = auth;
        return this;
    }

    public HttpRequest contentsType(String contentType) {
        this.contentsType = contentType;
        return this;
    }

    public HttpRequest accept(String accept) {
        this.accept = accept;
        return this;
    }

    public HttpRequest path(String path) {
        this.uriBuilder.path(path);
        return this;
    }

    public HttpRequest queryParam(String name, String value) {
        this.uriBuilder.queryParam(name, value);
        return this;
    }

    public HttpRequest queryParam(String name, Integer value) {
        if (value != null) {
            this.uriBuilder.queryParam(name, value.toString());
        }
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    HttpRequest bypassFilters() {
        this.bypassFilters = true;
        return this;
    }

    public abstract HttpResponse executeRequest(HttpClient.Method var1, Object var2) throws HttpClientException;

    @Override
    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    @Override
    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    @Override
    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    @Override
    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }

    public HttpResponse postForm(Object obj) {
        return this.contentsType("application/x-www-form-urlencoded").post(obj);
    }

    public HttpRequest resolveTemplate(String name, String value) {
        this.uriBuilder.resolveTemplate(name, value);
        return this;
    }

    public <E extends Exception> ExecutableHttpRequest<E, RuntimeException> unwrap(Class<E> ex) {
        return new HttpRequestWrapper<E, RuntimeException>(this, ex, RuntimeException.class);
    }

    public <E1 extends Exception, E2 extends Exception> ExecutableHttpRequest<E1, E2> unwrap(Class<E1> ex1, Class<E2> ex2) {
        return new HttpRequestWrapper<E1, E2>(this, ex1, ex2);
    }
}

