/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.zip.GZIPOutputStream;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.RequestContextImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseHttpRequest
extends HttpRequest {
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    protected BaseHttpRequest(HttpRuntimeConfig config, URI baseUri) {
        super(config, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        HttpResponse httpResponse;
        URI uri = this.uriBuilder.build();
        RequestContextImpl requestContext = new RequestContextImpl(this.headers, uri, method, body);
        ResponseContext responseContext = null;
        RuntimeException error = null;
        try {
            this.prepareRequest(requestContext);
            responseContext = this.processResponse(uri, method, body, requestContext);
            this.processResponseFilters(responseContext);
            httpResponse = this.config.responseFactory().make(responseContext, this.config.getMapper());
        }
        catch (RuntimeException e) {
            try {
                error = e;
                error = this.processCallbacks(requestContext, responseContext, error);
                this.cleanUp(responseContext, error);
            }
            catch (Throwable throwable) {
                error = this.processCallbacks(requestContext, responseContext, error);
                this.cleanUp(responseContext, error);
                throw throwable;
            }
        }
        error = this.processCallbacks(requestContext, responseContext, error);
        this.cleanUp(responseContext, error);
        return httpResponse;
        throw error;
    }

    protected void prepareRequest(RequestContext context) {
        this.headers.put("Accept", this.accept);
        HttpClient.Method method = context.getMethod();
        if (method == HttpClient.Method.PUT || method == HttpClient.Method.POST) {
            this.headers.put("Content-Type", this.contentsType);
        }
        if (!this.config.isDisableCompression()) {
            this.headers.put("Accept-Encoding", "gzip;q=1.0, deflate;q=0.9");
            if (context.doesOutput()) {
                this.headers.put("Content-Encoding", "gzip");
            }
        }
        this.processRequestFilters(context);
        HttpAuthentication auth = this.auth;
        if (auth != null) {
            auth.applyToHttpRequest(context);
            auth.start();
        }
    }

    protected ResponseContext processResponse(URI uri, HttpClient.Method method, Object body, RequestContext requestContext) {
        try {
            return this.sendAndReceive(uri, method, body, requestContext);
        }
        catch (ProtocolException e) {
            throw new HttpClientException(String.format("Cannot perform request against '%s'. Invalid protocol %s", new Object[]{uri, method}), e);
        }
        catch (MalformedURLException e) {
            throw new HttpClientException(String.format("Cannot perform %s request. Malformed Url for %s", new Object[]{method, uri}), e);
        }
        catch (SocketTimeoutException e) {
            throw new HttpClientReadTimeoutException(String.format("Cannot finish %s request against '%s'. Timeout while waiting for response with a timeout of %ds", new Object[]{method, uri, this.config.getReadTimeoutMillis() / 1000}), e);
        }
        catch (IOException e) {
            throw new HttpClientException(String.format("Failed to execute %s request against '%s'.", new Object[]{method, uri}), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract ResponseContext sendAndReceive(URI var1, HttpClient.Method var2, Object var3, RequestContext var4) throws IOException, InterruptedException;

    protected void processRequestFilters(RequestContext requestContext) {
        if (!this.bypassFilters) {
            this.config.getRequestFilters().forEach(requestFilter -> requestFilter.filter(requestContext));
        }
    }

    protected void processResponseFilters(ResponseContext responseContext) {
        if (!this.bypassFilters) {
            this.config.getResponseFilters().forEach(responseFilter -> responseFilter.filter(responseContext));
        }
    }

    protected RuntimeException processCallbacks(RequestContext requestContext, ResponseContext responseContext, RuntimeException originalError) {
        List<BiConsumer<ResponseContext, Exception>> callbacks = requestContext.getResponseCallbacks();
        RuntimeException error = originalError;
        if (callbacks != null) {
            for (BiConsumer<ResponseContext, Exception> callback : callbacks) {
                try {
                    callback.accept(responseContext, originalError);
                }
                catch (RuntimeException e) {
                    if (error == null) {
                        error = e;
                        continue;
                    }
                    error.addSuppressed(e);
                }
            }
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp(ResponseContext responseContext, RuntimeException error) {
        try {
            HttpAuthentication auth = this.auth;
            if (auth != null) {
                auth.close();
            }
        }
        finally {
            if (responseContext != null) {
                responseContext.close(error);
            }
        }
    }

    protected void writeToOutputStream(RequestContext context, OutputStream outputStream) throws IOException {
        Object body = context.getBody().orElseThrow(() -> new IllegalStateException("No request body"));
        try (OutputStream out = this.wrapOutputStream(outputStream);){
            if (context.isFormEncoded()) {
                this.writeFormData(out, body);
            } else {
                this.writeBody(out, body);
            }
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new HttpClientException(String.format("Cannot serialize body of %s request against '%s'. Unable to serialize %s", new Object[]{context.getMethod(), context.getUri(), body.getClass()}), e);
        }
    }

    private OutputStream wrapOutputStream(OutputStream base) throws IOException {
        return this.config.isDisableCompression() ? base : new GZIPOutputStream(base);
    }

    private void writeBody(OutputStream out, Object body) throws IOException {
        Class<?> bodyType = body.getClass();
        if (bodyType != String.class) {
            ObjectWriter writer = this.config.getMapper().writer();
            if (this.config.getJsonView() != null) {
                writer = writer.withView(this.config.getJsonView());
            }
            writer.forType(bodyType).writeValue(out, body);
        } else {
            out.write(((String)body).getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeFormData(OutputStream out, Object body) throws IOException {
        ObjectMapper mapper = this.config.getMapper();
        Map map = (Map)mapper.convertValue(body, MAP_TYPE);
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!first) {
                out.write(38);
            } else {
                first = false;
            }
            String key = URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.name());
            String value = URLEncoder.encode((String)mapper.convertValue(entry.getValue(), String.class), StandardCharsets.UTF_8.name());
            out.write(key.getBytes(StandardCharsets.UTF_8));
            out.write(61);
            out.write(value.getBytes(StandardCharsets.UTF_8));
        }
    }
}

