/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import com.google.errorprone.annotations.FormatMethod;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.client.http.impl.HttpHeaders;

public final class HttpUtils {
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final String GZIP_DEFLATE = "gzip;q=1.0, deflate;q=0.9";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";

    private HttpUtils() {
    }

    @FormatMethod
    public static void checkArgument(boolean expression, String msg, Object ... vars) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(msg, vars));
        }
    }

    public static String checkNonNullTrim(String str) {
        Objects.requireNonNull(str);
        return str.trim();
    }

    public static void applyHeaders(HttpHeaders headers, URLConnection con) {
        for (HttpHeaders.HttpHeader header : headers.allHeaders()) {
            for (String value : header.getValues()) {
                con.addRequestProperty(header.getName(), value);
            }
        }
    }

    public static Map<String, String> parseQueryString(String query) {
        String[] pairs;
        if (query == null) {
            throw new IllegalArgumentException("Missing query string");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            String value;
            String name;
            int idx = pair.indexOf("=");
            try {
                name = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            params.put(name, value);
        }
        return params;
    }

    public static boolean isHttpUri(URI uri) {
        return "http".equalsIgnoreCase(uri.getScheme()) || "https".equalsIgnoreCase(uri.getScheme());
    }
}

