/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.Objects;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.TokenExchangeRequest;
import org.projectnessie.client.auth.oauth2.TokenExchangeResponse;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.auth.oauth2.TypedToken;

class TokenExchangeFlow
extends AbstractFlow {
    TokenExchangeFlow(OAuth2ClientConfig config) {
        super(config);
    }

    @Override
    public Tokens fetchNewTokens(Tokens currentTokens) {
        TokenExchangeConfig tokenExchangeConfig = this.config.getTokenExchangeConfig();
        AccessToken accessToken = currentTokens == null ? null : currentTokens.getAccessToken();
        RefreshToken refreshToken = currentTokens == null ? null : currentTokens.getRefreshToken();
        TypedToken subjectToken = tokenExchangeConfig.getSubjectTokenProvider().apply(accessToken, refreshToken);
        TypedToken actorToken = tokenExchangeConfig.getActorTokenProvider().apply(accessToken, refreshToken);
        Objects.requireNonNull(subjectToken, "Cannot execute token exchange: missing required subject token");
        TokenExchangeRequest.Builder request = TokenExchangeRequest.builder().subjectToken(subjectToken.getPayload()).subjectTokenType(subjectToken.getTokenType()).actorToken(actorToken == null ? null : actorToken.getPayload()).actorTokenType(actorToken == null ? null : actorToken.getTokenType()).resource(tokenExchangeConfig.getResource().orElse(null)).audience(tokenExchangeConfig.getAudience().orElse(null)).requestedTokenType(tokenExchangeConfig.getRequestedTokenType());
        return this.invokeTokenEndpoint(request, TokenExchangeResponse.class);
    }
}

