/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.client.builder.BaseGetDiffBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.rest.v2.HttpApiV2;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.Reference;

final class HttpGetDiff
extends BaseGetDiffBuilder<DiffParams> {
    private final HttpClient client;
    private final HttpApiV2 api;

    HttpGetDiff(HttpClient client, HttpApiV2 api) {
        super(DiffParams::forNextPage);
        this.client = client;
        this.api = api;
    }

    @Override
    protected DiffParams params() {
        return DiffParams.builder().fromRef(Reference.toPathString((String)this.fromRefName, (String)this.fromHashOnRef)).toRef(Reference.toPathString((String)this.toRefName, (String)this.toHashOnRef)).maxRecords(this.maxRecords).minKey(this.minKey).maxKey(this.maxKey).prefixKey(this.prefixKey).filter(this.filter).requestedKeys((Iterable)this.keys).build();
    }

    @Override
    public DiffResponse get(DiffParams params) throws NessieNotFoundException {
        HttpRequest req = this.client.newRequest().path("trees/{from}/diff/{to}").resolveTemplate("from", params.getFromRef()).resolveTemplate("to", params.getToRef()).queryParam("max-records", params.maxRecords()).queryParam("page-token", params.pageToken()).queryParam("filter", params.getFilter());
        params.getRequestedKeys().forEach(k -> req.queryParam("key", this.api.toPathString((ContentKey)k)));
        ContentKey k2 = params.minKey();
        if (k2 != null) {
            req.queryParam("min-key", this.api.toPathString(k2));
        }
        if ((k2 = params.maxKey()) != null) {
            req.queryParam("max-key", this.api.toPathString(k2));
        }
        if ((k2 = params.prefixKey()) != null) {
            req.queryParam("prefix-key", this.api.toPathString(k2));
        }
        return req.unwrap(NessieNotFoundException.class).get().readEntity(DiffResponse.class);
    }
}

