/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import org.projectnessie.api.v2.ConfigApi;
import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.nessie.combined.CombinedClientImpl;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.services.impl.ContentApiImpl;
import org.projectnessie.services.impl.DiffApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.rest.RestV2ConfigResource;
import org.projectnessie.services.rest.RestV2TreeResource;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.versionstore.VersionStoreImpl;

public class CombinedClientBuilder
extends NessieClientBuilder.AbstractNessieClientBuilder {
    private Persist persist;
    private RestV2ConfigResource configResource;
    private RestV2TreeResource treeResource;

    public String name() {
        return "Combined";
    }

    public int priority() {
        return 50;
    }

    public CombinedClientBuilder withConfigResource(RestV2ConfigResource configResource) {
        this.configResource = configResource;
        return this;
    }

    public CombinedClientBuilder withTreeResource(RestV2TreeResource treeResource) {
        this.treeResource = treeResource;
        return this;
    }

    public CombinedClientBuilder withPersist(Persist persist) {
        this.persist = persist;
        return this;
    }

    public <API extends NessieApi> API build(Class<API> apiContract) {
        RestV2ConfigResource configResource = this.configResource;
        RestV2TreeResource treeResource = this.treeResource;
        if (configResource != null && treeResource != null) {
            CombinedClientImpl r = new CombinedClientImpl((ConfigApi)configResource, (TreeApi)treeResource);
            return (API)r;
        }
        if (configResource != null || treeResource != null) {
            throw new IllegalStateException("configResource or treeResource configured - this indicates a product bug");
        }
        ServerConfig serverConfig = new ServerConfig(){

            public String getDefaultBranch() {
                return "main";
            }

            public boolean sendStacktraceToClient() {
                return true;
            }
        };
        VersionStoreImpl versionStore = new VersionStoreImpl(this.persist);
        Authorizer authorizer = c -> AbstractBatchAccessChecker.NOOP_ACCESS_CHECKER;
        AccessContext accessContext = () -> null;
        ConfigApiImpl configService = new ConfigApiImpl(serverConfig, (VersionStore)versionStore, authorizer, accessContext, 2);
        TreeApiImpl treeService = new TreeApiImpl(serverConfig, (VersionStore)versionStore, authorizer, accessContext);
        ContentApiImpl contentService = new ContentApiImpl(serverConfig, (VersionStore)versionStore, authorizer, accessContext);
        DiffApiImpl diffService = new DiffApiImpl(serverConfig, (VersionStore)versionStore, authorizer, accessContext);
        configResource = new RestV2ConfigResource(serverConfig, (VersionStore)versionStore, authorizer, accessContext);
        treeResource = new RestV2TreeResource((ConfigService)configService, (TreeService)treeService, (ContentService)contentService, (DiffService)diffService);
        CombinedClientImpl r = new CombinedClientImpl((ConfigApi)configResource, (TreeApi)treeResource);
        return (API)r;
    }
}

