/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import org.projectnessie.api.v2.ConfigApi;
import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignReferenceBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateReferenceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteReferenceBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetReferenceBuilder;
import org.projectnessie.client.api.GetRepositoryConfigBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.ReferenceHistoryBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.Reference;
import org.projectnessie.nessie.combined.CombinedAssignBranch;
import org.projectnessie.nessie.combined.CombinedAssignReference;
import org.projectnessie.nessie.combined.CombinedAssignTag;
import org.projectnessie.nessie.combined.CombinedCommitMultipleOperations;
import org.projectnessie.nessie.combined.CombinedCreateReference;
import org.projectnessie.nessie.combined.CombinedDeleteBranch;
import org.projectnessie.nessie.combined.CombinedDeleteReference;
import org.projectnessie.nessie.combined.CombinedDeleteTag;
import org.projectnessie.nessie.combined.CombinedGetAllReferences;
import org.projectnessie.nessie.combined.CombinedGetCommitLog;
import org.projectnessie.nessie.combined.CombinedGetContent;
import org.projectnessie.nessie.combined.CombinedGetDiff;
import org.projectnessie.nessie.combined.CombinedGetEntries;
import org.projectnessie.nessie.combined.CombinedGetReference;
import org.projectnessie.nessie.combined.CombinedGetRepositoryConfig;
import org.projectnessie.nessie.combined.CombinedMergeReference;
import org.projectnessie.nessie.combined.CombinedReferenceHistory;
import org.projectnessie.nessie.combined.CombinedTransplantCommits;
import org.projectnessie.nessie.combined.CombinedUpdateRepositoryConfig;

final class CombinedClientImpl
implements NessieApiV2 {
    private final ConfigApi configApi;
    private final TreeApi treeApi;

    CombinedClientImpl(ConfigApi configApi, TreeApi treeApi) {
        this.configApi = configApi;
        this.treeApi = treeApi;
    }

    static RuntimeException maybeWrapException(RuntimeException e) {
        if (e instanceof IllegalArgumentException) {
            NessieBadRequestException ex = new NessieBadRequestException((NessieError)ImmutableNessieError.builder().errorCode(ErrorCode.BAD_REQUEST).message(e.getMessage()).status(400).reason("Bad request").build());
            ex.initCause((Throwable)e);
            return ex;
        }
        return e;
    }

    public void close() {
    }

    public NessieConfiguration getConfig() {
        return this.configApi.getConfig();
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        return (Branch)this.treeApi.getReferenceByName(GetReferenceParams.builder().ref("-").build()).getReference();
    }

    public GetContentBuilder getContent() {
        return new CombinedGetContent(this.treeApi);
    }

    public GetAllReferencesBuilder getAllReferences() {
        return new CombinedGetAllReferences(this.treeApi);
    }

    public CreateReferenceBuilder createReference() {
        return new CombinedCreateReference(this.treeApi);
    }

    public GetReferenceBuilder getReference() {
        return new CombinedGetReference(this.treeApi);
    }

    public ReferenceHistoryBuilder referenceHistory() {
        return new CombinedReferenceHistory(this.treeApi);
    }

    public GetEntriesBuilder getEntries() {
        return new CombinedGetEntries(this.treeApi);
    }

    public GetCommitLogBuilder getCommitLog() {
        return new CombinedGetCommitLog(this.treeApi);
    }

    public TransplantCommitsBuilder transplantCommitsIntoBranch() {
        return new CombinedTransplantCommits(this.treeApi);
    }

    public MergeReferenceBuilder mergeRefIntoBranch() {
        return new CombinedMergeReference(this.treeApi);
    }

    public CommitMultipleOperationsBuilder commitMultipleOperations() {
        return new CombinedCommitMultipleOperations(this.treeApi);
    }

    public GetDiffBuilder getDiff() {
        return new CombinedGetDiff(this.treeApi);
    }

    public GetRepositoryConfigBuilder getRepositoryConfig() {
        return new CombinedGetRepositoryConfig(this.configApi);
    }

    public UpdateRepositoryConfigBuilder updateRepositoryConfig() {
        return new CombinedUpdateRepositoryConfig(this.configApi);
    }

    public DeleteReferenceBuilder<Reference> deleteReference() {
        return new CombinedDeleteReference(this.treeApi);
    }

    public AssignReferenceBuilder<Reference> assignReference() {
        return new CombinedAssignReference(this.treeApi);
    }

    @Deprecated
    public AssignTagBuilder assignTag() {
        return new CombinedAssignTag(this.treeApi);
    }

    @Deprecated
    public AssignBranchBuilder assignBranch() {
        return new CombinedAssignBranch(this.treeApi);
    }

    @Deprecated
    public DeleteTagBuilder deleteTag() {
        return new CombinedDeleteTag(this.treeApi);
    }

    @Deprecated
    public DeleteBranchBuilder deleteBranch() {
        return new CombinedDeleteBranch(this.treeApi);
    }
}

