/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import java.util.Map;
import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.client.builder.BaseGetContentBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.nessie.combined.CombinedClientImpl;

final class CombinedGetContent
extends BaseGetContentBuilder {
    private final TreeApi treeApi;

    CombinedGetContent(TreeApi treeApi) {
        this.treeApi = treeApi;
    }

    public Map<ContentKey, Content> get() throws NessieNotFoundException {
        return this.getWithResponse().toContentsMap();
    }

    public ContentResponse getSingle(ContentKey key) throws NessieNotFoundException {
        if (!this.request.build().getRequestedKeys().isEmpty()) {
            throw new IllegalStateException("Must not use getSingle() with key() or keys(), pass the single key to getSingle()");
        }
        try {
            String ref = Reference.toPathString((String)this.refName, (String)this.hashOnRef);
            if (ref.isEmpty()) {
                ref = "-";
            }
            return this.treeApi.getContent(key, ref, false, this.forWrite);
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }

    public GetMultipleContentsResponse getWithResponse() throws NessieNotFoundException {
        try {
            String ref = Reference.toPathString((String)this.refName, (String)this.hashOnRef);
            if (ref.isEmpty()) {
                ref = "-";
            }
            return this.treeApi.getMultipleContents(ref, (GetMultipleContentsRequest)this.request.build(), false, this.forWrite);
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }
}

