/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.projectnessie.api.v2.ConfigApi;
import org.projectnessie.client.api.GetRepositoryConfigBuilder;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.RepositoryConfigResponse;
import org.projectnessie.nessie.combined.CombinedClientImpl;

final class CombinedGetRepositoryConfig
implements GetRepositoryConfigBuilder {
    private final ConfigApi configApi;
    private final Set<RepositoryConfig.Type> types = new HashSet<RepositoryConfig.Type>();

    CombinedGetRepositoryConfig(ConfigApi configApi) {
        this.configApi = configApi;
    }

    public GetRepositoryConfigBuilder type(RepositoryConfig.Type type) {
        this.types.add(Objects.requireNonNull(type, "repository config type is null"));
        return this;
    }

    public RepositoryConfigResponse get() {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("repository config types to retrieve must be set");
        }
        try {
            return this.configApi.getRepositoryConfig(this.types.stream().map(RepositoryConfig.Type::name).collect(Collectors.toList()));
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }
}

