/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.api.v2.params.ImmutableMerge;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.builder.BaseMergeReferenceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.nessie.combined.CombinedClientImpl;

final class CombinedMergeReference
extends BaseMergeReferenceBuilder {
    private final TreeApi treeApi;

    public CombinedMergeReference(TreeApi treeApi) {
        this.treeApi = treeApi;
    }

    public MergeReferenceBuilder keepIndividualCommits(boolean keepIndividualCommits) {
        if (keepIndividualCommits) {
            throw new IllegalArgumentException("Commits are always squashed during merge operations.");
        }
        return this;
    }

    public MergeResponse merge() throws NessieNotFoundException, NessieConflictException {
        ImmutableMerge.Builder merge = ImmutableMerge.builder().fromHash(this.fromHash).fromRefName(this.fromRefName).message(this.message).commitMeta(this.commitMeta).isDryRun(this.dryRun).isFetchAdditionalInfo(this.fetchAdditionalInfo).isReturnConflictAsResult(this.returnConflictAsResult);
        if (this.defaultMergeMode != null) {
            merge.defaultKeyMergeMode(this.defaultMergeMode);
        }
        if (this.mergeModes != null) {
            merge.keyMergeModes(this.mergeModes.values());
        }
        try {
            return this.treeApi.mergeRefIntoBranch(Reference.toPathString((String)this.branchName, (String)this.hash), (Merge)merge.build());
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }
}

