/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieClientCustomizer;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.nessie.combined.CombinedClientBuilder;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.inmemory.InmemoryBackendConfig;
import org.projectnessie.versioned.storage.inmemory.InmemoryBackendFactory;

public class CombinedNessieClientFactory
implements Extension,
ParameterResolver,
BeforeEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CombinedNessieClientFactory.class});
    public static final String API_VERSION_SEGMENT_TYPE = "nessie-api";
    private static final NessieApiVersion DEFAULT_API_VERSION = NessieApiVersion.V2;

    private boolean isNessieClient(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(NessieClientFactory.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.isNessieClient(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isNessieClient(parameterContext)) {
            return this.clientFactoryForContext(extensionContext);
        }
        throw new IllegalStateException("Unsupported parameter: " + String.valueOf(parameterContext));
    }

    private NessieClientFactory clientFactoryForContext(ExtensionContext extensionContext) {
        NessieApiVersion apiVersion = CombinedNessieClientFactory.apiVersion(extensionContext);
        List customizers = extensionContext.getTestInstances().map(i -> i.getAllInstances().stream().filter(ti -> ti instanceof NessieClientCustomizer).map(ti -> (NessieClientCustomizer)ti).collect(Collectors.toList())).orElse(Collections.emptyList());
        Persist persist = this.persist(extensionContext);
        if (!customizers.isEmpty()) {
            final NessieClientCustomizer testCustomizer = (builder, version) -> {
                for (NessieClientCustomizer customizer : customizers) {
                    builder = customizer.configure(builder, version);
                }
                return builder;
            };
            return new ClientFactory(apiVersion, persist){

                @Override
                @Nonnull
                public NessieApiV1 make(NessieClientCustomizer customizer) {
                    return super.make((builder, version) -> customizer.configure(testCustomizer.configure(builder, version), version));
                }
            };
        }
        return new ClientFactory(apiVersion, persist);
    }

    private Persist persist(ExtensionContext extensionContext) {
        return (Persist)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)"persistSupplier", x -> {
            PersistFactory persistFactory = this.backend(extensionContext).createFactory();
            return persistFactory.newPersist((StoreConfig)StoreConfig.Adjustable.empty());
        }, Persist.class);
    }

    private Backend backend(ExtensionContext extensionContext) {
        return (Backend)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)"backendSupplier", x -> {
            InmemoryBackendFactory backendFactory = new InmemoryBackendFactory();
            return backendFactory.buildBackend((Object)((InmemoryBackendConfig)backendFactory.newConfigInstance()));
        }, Backend.class);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        Logics.repositoryLogic((Persist)this.persist(extensionContext)).initialize("main");
    }

    static NessieApiVersion apiVersion(ExtensionContext context) {
        return UniqueId.parse((String)context.getUniqueId()).getSegments().stream().filter(s -> API_VERSION_SEGMENT_TYPE.equals(s.getType())).map(UniqueId.Segment::getValue).findFirst().map(NessieApiVersion::valueOf).orElse(DEFAULT_API_VERSION);
    }

    private static class ClientFactory
    implements NessieClientFactory,
    Serializable {
        private final NessieApiVersion apiVersion;
        private final Persist persist;

        private ClientFactory(NessieApiVersion apiVersion, Persist persist) {
            this.apiVersion = apiVersion;
            this.persist = persist;
        }

        public NessieApiVersion apiVersion() {
            return this.apiVersion;
        }

        @Nonnull
        public NessieApiV1 make(NessieClientCustomizer customizer) {
            CombinedClientBuilder clientBuilder = ((CombinedClientBuilder)NessieClientBuilder.createClientBuilder((String)"Combined", null).asInstanceOf(CombinedClientBuilder.class)).withPersist(this.persist);
            NessieClientBuilder builder = customizer.configure((NessieClientBuilder)clientBuilder, this.apiVersion);
            return this.apiVersion.build(builder);
        }
    }
}

