/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import org.projectnessie.api.v2.TreeApi;
import org.projectnessie.api.v2.params.ImmutableTransplant;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.builder.BaseTransplantCommitsBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.nessie.combined.CombinedClientImpl;

final class CombinedTransplantCommits
extends BaseTransplantCommitsBuilder {
    private final TreeApi treeApi;

    public CombinedTransplantCommits(TreeApi treeApi) {
        this.treeApi = treeApi;
    }

    public TransplantCommitsBuilder keepIndividualCommits(boolean keepIndividualCommits) {
        if (!keepIndividualCommits) {
            throw new IllegalArgumentException("Individual commits are always kept during transplant operations.");
        }
        return this;
    }

    public MergeResponse transplant() throws NessieNotFoundException, NessieConflictException {
        ImmutableTransplant.Builder transplant = ImmutableTransplant.builder().message(this.message).fromRefName(this.fromRefName).hashesToTransplant((Iterable)this.hashesToTransplant).isDryRun(this.dryRun).isReturnConflictAsResult(this.returnConflictAsResult).isFetchAdditionalInfo(this.fetchAdditionalInfo);
        if (this.defaultMergeMode != null) {
            transplant.defaultKeyMergeMode(this.defaultMergeMode);
        }
        if (this.mergeModes != null) {
            transplant.keyMergeModes(this.mergeModes.values());
        }
        try {
            return this.treeApi.transplantCommitsIntoBranch(Reference.toPathString((String)this.branchName, (String)this.hash), (Transplant)transplant.build());
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }
}

