/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.combined;

import org.projectnessie.api.v2.ConfigApi;
import org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.model.ImmutableUpdateRepositoryConfigRequest;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.UpdateRepositoryConfigRequest;
import org.projectnessie.model.UpdateRepositoryConfigResponse;
import org.projectnessie.nessie.combined.CombinedClientImpl;

final class CombinedUpdateRepositoryConfig
implements UpdateRepositoryConfigBuilder {
    private final ConfigApi configApi;
    private RepositoryConfig update;

    CombinedUpdateRepositoryConfig(ConfigApi configApi) {
        this.configApi = configApi;
    }

    public UpdateRepositoryConfigBuilder repositoryConfig(RepositoryConfig update) {
        if (this.update != null) {
            throw new IllegalStateException("repository config to update has already been set");
        }
        this.update = update;
        return this;
    }

    public UpdateRepositoryConfigResponse update() throws NessieConflictException {
        if (this.update == null) {
            throw new IllegalStateException("repository config to update must be set");
        }
        ImmutableUpdateRepositoryConfigRequest req = ImmutableUpdateRepositoryConfigRequest.builder().config(this.update).build();
        try {
            return this.configApi.updateRepositoryConfig((UpdateRepositoryConfigRequest)req);
        }
        catch (RuntimeException e) {
            throw CombinedClientImpl.maybeWrapException(e);
        }
    }
}

