/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.api.Version;

final class ClientKey {
    private final Version version;
    private final String builderClass;
    private final Class<? extends NessieApi> type;
    private final Map<String, String> configs;

    ClientKey(Version version, String builderClass, Class<? extends NessieApi> type, Map<String, String> configs) {
        this.version = Objects.requireNonNull(version);
        this.builderClass = Objects.requireNonNull(builderClass);
        this.type = Objects.requireNonNull(type);
        this.configs = Objects.requireNonNull(configs);
    }

    Version getVersion() {
        return this.version;
    }

    String getBuilderClass() {
        return this.builderClass;
    }

    Class<? extends NessieApi> getType() {
        return this.type;
    }

    Map<String, String> getConfigs() {
        return this.configs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientKey clientKey = (ClientKey)o;
        return Objects.equals(this.version, clientKey.version) && Objects.equals(this.builderClass, clientKey.builderClass) && Objects.equals(this.type, clientKey.type) && Objects.equals(this.configs, clientKey.configs);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.builderClass, this.type, this.configs);
    }

    public String toString() {
        return String.format("client-%s-%s-%s-%s", this.getVersion(), this.type.getName(), this.builderClass, this.configs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("_")));
    }
}

