/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.projectnessie.tools.compatibility.api.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JerseyForOldServerClassLoader
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyForOldServerClassLoader.class);
    static final String CLASS_PREFIX = "org.projectnessie.tools.compatibility.jersey.";
    private final ClassLoader currentVersionClassLoader;
    private final Version version;

    JerseyForOldServerClassLoader(Version version, ClassLoader parent, ClassLoader currentVersionClassLoader) {
        super(parent);
        this.version = version;
        this.currentVersionClassLoader = currentVersionClassLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block11: {
            if (!name.startsWith(CLASS_PREFIX)) {
                return super.findClass(name);
            }
            String path = name.replace('.', '/') + ".class";
            URL url = this.currentVersionClassLoader.getResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            LOGGER.debug("Loading class {}' for Nessie server version '{}'", (Object)name, (Object)this.version);
            InputStream in = url.openConnection().getInputStream();
            try {
                int rd;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((rd = in.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
                byte[] bytes = out.toByteArray();
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return clazz;
    }
}

