/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.tools.compatibility.api.TargetVersion;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.AbstractMultiVersionExtension;
import org.projectnessie.tools.compatibility.internal.AbstractNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.AnnotatedFields;
import org.projectnessie.tools.compatibility.internal.GlobalForClass;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.TemporaryDirectory;

public class NessieUpgradesExtension
extends AbstractMultiVersionExtension {
    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (OS.MAC.isCurrentOs()) {
            return ConditionEvaluationResult.disabled((String)"Disabled on macOS due to SIGSEGV issues with RocksDB");
        }
        return super.evaluateExecutionCondition(context);
    }

    public void beforeAll(ExtensionContext context) {
        Version version = this.populateNessieVersionAnnotatedFields(context, null);
        if (version == null) {
            return;
        }
        ServerKey serverKey = this.buildServerKey(version, context);
        NessieServer nessieServer = NessieServer.nessieServer(context, serverKey, this.initializeRepositorySupplier(context, serverKey), c -> {});
        this.populateFields(context, null, version, ctx -> nessieServer);
    }

    public void beforeEach(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();
        Version version = this.populateNessieVersionAnnotatedFields(context, testInstance);
        if (version == null) {
            return;
        }
        ServerKey serverKey = this.buildServerKey(version, context);
        NessieServer nessieServer = NessieServer.nessieServerExisting(context, serverKey);
        this.populateFields(context, testInstance, version, ctx -> nessieServer);
    }

    private ServerKey buildServerKey(Version version, ExtensionContext context) {
        Path tempDir = GlobalForClass.globalForClass(context).getOrCompute("temporary-directory", x -> new TemporaryDirectory(), TemporaryDirectory.class).getPath();
        Map<String, String> configuration = Collections.singletonMap("nessie.store.database.path", tempDir.resolve("persist").toString());
        return ServerKey.forContext(context, version, "RocksDB", configuration);
    }

    private BooleanSupplier initializeRepositorySupplier(ExtensionContext context, ServerKey serverKey) {
        return () -> GlobalForClass.globalForClass(context).getOrCompute("initialize-repository-" + serverKey.getStorageName(), k -> new AtomicBoolean(true), AtomicBoolean.class).getAndSet(false);
    }

    private void populateFields(ExtensionContext context, Object instance, Version version, Function<ExtensionContext, NessieServer> nessieServerSupplier) {
        AnnotatedFields.populateNessieApiFields(context, instance, TargetVersion.TESTED, field -> AbstractNessieApiHolder.apiInstanceForField(context, field, version, nessieServerSupplier));
    }
}

