/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.DependencyResolver;

final class OldNessie {
    private OldNessie() {
    }

    static ClassLoader oldNessieClassLoader(Version version, List<String> artifactIds) throws DependencyResolutionException {
        Function<String, Dependency> nessieDep = artifactId -> new Dependency((Artifact)new DefaultArtifact("org.projectnessie.nessie", artifactId, "jar", version.toString()), "compile");
        String mainArtifactId = artifactIds.get(0);
        Dependency mainDependency = nessieDep.apply(mainArtifactId);
        Consumer<CollectRequest> collect = r -> {
            r.setRoot(mainDependency);
            for (int i = 1; i < artifactIds.size(); ++i) {
                r.addDependency((Dependency)nessieDep.apply((String)artifactIds.get(i)));
            }
        };
        Stream<Artifact> resolvedArtifacts = DependencyResolver.resolve(collect);
        return DependencyResolver.toClassLoader(version.toString(), resolvedArtifacts, null);
    }
}

