/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.client.rest.v1.HttpApiV1;
import org.projectnessie.tools.compatibility.api.NessieBaseUri;
import org.projectnessie.tools.compatibility.api.TargetVersion;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.AbstractMultiVersionExtension;
import org.projectnessie.tools.compatibility.internal.AbstractNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.AnnotatedFields;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;

public class OlderNessieServersExtension
extends AbstractMultiVersionExtension {
    public void beforeAll(ExtensionContext context) {
        this.populateFields(context, null);
    }

    public void beforeEach(ExtensionContext context) {
        this.populateFields(context, context.getRequiredTestInstance());
    }

    private void populateFields(ExtensionContext context, Object instance) {
        Version version = this.populateNessieVersionAnnotatedFields(context, instance);
        if (version == null) {
            return;
        }
        BooleanSupplier initializeRepository = () -> true;
        ServerKey serverKey = ServerKey.forContext(context, version, "In-Memory", Collections.emptyMap());
        NessieServer nessieServer = NessieServer.nessieServer(Util.classContext(context), serverKey, initializeRepository, c -> {});
        Function<Field, Object> fieldValue = field -> AbstractNessieApiHolder.apiInstanceForField(Util.classContext(context), field, Version.CURRENT, ctx -> nessieServer);
        AnnotatedFields.populateNessieApiFields(context, instance, TargetVersion.TESTED, fieldValue);
        URI serverUri = nessieServer.getUri(HttpApiV1.class);
        URI baseUri = serverUri.resolve("/");
        AnnotatedFields.populateAnnotatedFields(context, instance, NessieBaseUri.class, a -> true, f -> baseUri);
    }
}

