/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.projectnessie.tools.compatibility.api.Version;

final class VersionsToExercise {
    public static final String NESSIE_VERSIONS_PROPERTY = "nessie.versions";

    private VersionsToExercise() {
    }

    static SortedSet<Version> versionsFromValue(String value) {
        TreeSet versions = Stream.of(value).filter(Objects::nonNull).flatMap(v -> Arrays.stream(v.split(","))).map(String::trim).filter(s -> !s.isEmpty()).map(Version::parseVersion).collect(Collectors.toCollection(TreeSet::new));
        if (versions.isEmpty()) {
            throw new IllegalArgumentException("No versions to test");
        }
        return versions;
    }

    static String valueFromResource(String propertyName) {
        URL res = Thread.currentThread().getContextClassLoader().getResource("META-INF/nessie-compatibility.properties");
        if (res != null) {
            String string;
            block9: {
                InputStream in = res.openConnection().getInputStream();
                try {
                    Properties props = new Properties();
                    props.load(in);
                    string = props.getProperty(propertyName);
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                in.close();
            }
            return string;
        }
        return null;
    }

    public static SortedSet<Version> versionsForEngine(ConfigurationParameters configuration, String propertyName) {
        String value = configuration.get(propertyName).orElse(null);
        if (value == null) {
            value = System.getProperty(propertyName);
        }
        if (value == null) {
            value = VersionsToExercise.valueFromResource(propertyName);
        }
        if (value == null) {
            throw new IllegalStateException(String.format("Property '%s' not defined", propertyName));
        }
        return VersionsToExercise.versionsFromValue(value);
    }

    public static SortedSet<Version> versionsForEngine(ConfigurationParameters configuration) {
        return VersionsToExercise.versionsForEngine(configuration, NESSIE_VERSIONS_PROPERTY);
    }
}

