/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.api;

import java.util.Arrays;
import java.util.Objects;

public class Version
implements Comparable<Version> {
    public static final Version NEW_STORAGE_MODEL_WITH_COMPAT_TESTING = Version.parseVersion("0.55.0");
    public static final Version SPEC_VERSION_IN_CONFIG_V2 = Version.parseVersion("0.55.0");
    public static final Version SPEC_VERSION_IN_CONFIG_V2_SEMVER = Version.parseVersion("0.57.0");
    public static final Version SPEC_VERSION_IN_CONFIG_V2_GA = Version.parseVersion("0.59.0");
    public static final Version ACTUAL_VERSION_IN_CONFIG_V2 = Version.parseVersion("0.59.0");
    public static final Version MERGE_KEY_BEHAVIOR_FIX = Version.parseVersion("0.59.1");
    public static final Version NESSIE_URL_API_SUFFIX = Version.parseVersion("0.75.0");
    public static final String CURRENT_STRING = "current";
    public static final String NOT_CURRENT_STRING = "not-current";
    private final int[] tuple;
    public static final Version CURRENT = new Version(new int[]{Integer.MAX_VALUE});
    public static final Version NOT_CURRENT = new Version(new int[]{0x7FFFFFFE});

    private Version(int[] tuple) {
        this.tuple = tuple;
    }

    public static Version parseVersion(String version) {
        int i;
        if (CURRENT_STRING.equalsIgnoreCase(version)) {
            return CURRENT;
        }
        if (NOT_CURRENT_STRING.equalsIgnoreCase(version)) {
            return NOT_CURRENT;
        }
        Objects.requireNonNull(version, "Version mut not be null");
        int[] t = new int[8];
        int len = 0;
        while ((i = version.indexOf(46)) != -1) {
            t[len++] = Version.parsePart(version.substring(0, i));
            version = version.substring(i + 1);
        }
        t[len++] = Version.parsePart(version);
        return new Version(Arrays.copyOf(t, len));
    }

    private static int parsePart(String part) {
        int val;
        try {
            val = Integer.parseInt(part);
            if (val < 0 || val >= 0x7FFFFFFE) {
                throw new NumberFormatException();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version number part: " + part);
        }
        return val;
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLessThanOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isSame(Version version) {
        return this.compareTo(version) == 0;
    }

    @Override
    public int compareTo(Version o) {
        for (int i = 0; i < this.tuple.length || i < o.tuple.length; ++i) {
            int other;
            int mine = i < this.tuple.length ? this.tuple[i] : 0;
            int r = Integer.compare(mine, other = i < o.tuple.length ? o.tuple[i] : 0);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return Arrays.equals(this.tuple, version.tuple);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tuple);
    }

    public String toString() {
        if (CURRENT.equals(this)) {
            return CURRENT_STRING;
        }
        if (NOT_CURRENT.equals(this)) {
            return NOT_CURRENT_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tuple.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.tuple[i]);
        }
        return sb.toString();
    }
}

