/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.junit.engine.MultiEnvTestExtension;
import org.projectnessie.tools.compatibility.api.NessieVersion;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.api.VersionCondition;
import org.projectnessie.tools.compatibility.internal.AnnotatedFields;
import org.projectnessie.tools.compatibility.internal.VersionsToExercise;

abstract class AbstractMultiVersionExtension
implements BeforeAllCallback,
BeforeEachCallback,
ExecutionCondition,
MultiEnvTestExtension {
    private static final String NESSIE_VERSION_SEGMENT_TYPE = "nessie-version";
    private static final ConditionEvaluationResult PASS = ConditionEvaluationResult.enabled(null);

    AbstractMultiVersionExtension() {
    }

    public String segmentType() {
        return NESSIE_VERSION_SEGMENT_TYPE;
    }

    public List<String> allEnvironmentIds(ConfigurationParameters configuration) {
        try {
            return VersionsToExercise.versionsForEngine(configuration).stream().map(Objects::toString).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            return Collections.emptyList();
        }
    }

    private void checkExtensions(Class<?> testClass) {
        long count = AbstractMultiVersionExtension.multiVersionExtensionsForTestClass(Stream.of(testClass)).count();
        if (count > 1L) {
            throw new IllegalStateException(String.format("Test class %s contains more than one Nessie multi-version extension", testClass.getName()));
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<Version> version = AbstractMultiVersionExtension.nessieVersionFromContext(context);
        if (version.isEmpty()) {
            if (AbstractMultiVersionExtension.isNessieMultiVersionTest(context)) {
                return ConditionEvaluationResult.disabled((String)"(not running via multi-nessie-version engine)");
            }
            return ConditionEvaluationResult.enabled((String)"(not running via multi-nessie-versions engine)");
        }
        ConditionEvaluationResult classResult = context.getTestClass().map(c -> AbstractMultiVersionExtension.conditionCheck((Version)version.get(), c)).orElse(PASS);
        if (classResult.isDisabled()) {
            return classResult;
        }
        ConditionEvaluationResult methodResult = context.getTestMethod().map(m -> AbstractMultiVersionExtension.conditionCheck((Version)version.get(), m)).orElse(PASS);
        if (methodResult.isDisabled()) {
            return methodResult;
        }
        return PASS;
    }

    static boolean isNessieMultiVersionTest(ExtensionContext context) {
        return AbstractMultiVersionExtension.multiVersionExtensionsForTestClass(Stream.of((Class)context.getTestClass().orElse(null))).findAny().isPresent();
    }

    static Stream<Class<? extends AbstractMultiVersionExtension>> multiVersionExtensionsForTestClass(Stream<Class<?>> classStream) {
        return classStream.filter(Objects::nonNull).flatMap(c -> AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)c, ExtendWith.class).stream()).flatMap(e -> Arrays.stream(e.value())).filter(AbstractMultiVersionExtension.class::isAssignableFrom).map(c -> c);
    }

    static ConditionEvaluationResult conditionCheck(Version version, AnnotatedElement annotated) {
        Optional cond = AnnotationSupport.findAnnotation((AnnotatedElement)annotated, VersionCondition.class);
        if (cond.isPresent()) {
            VersionCondition versionCondition = (VersionCondition)cond.get();
            if (!versionCondition.minVersion().isEmpty() && Version.parseVersion(versionCondition.minVersion()).isGreaterThan(version)) {
                return ConditionEvaluationResult.disabled((String)String.format("%s requires minimum Nessie version '%s', but current Nessie version is '%s'", annotated, versionCondition.minVersion(), version));
            }
            if (!versionCondition.maxVersion().isEmpty() && Version.parseVersion(versionCondition.maxVersion()).isLessThan(version)) {
                return ConditionEvaluationResult.disabled((String)String.format("%s requires maximum Nessie version '%s', but current Nessie version is '%s'", annotated, versionCondition.maxVersion(), version));
            }
        }
        return PASS;
    }

    Version populateNessieVersionAnnotatedFields(ExtensionContext context, Object instance) {
        this.checkExtensions(context.getRequiredTestClass());
        Optional<Version> nessieVersion = AbstractMultiVersionExtension.nessieVersionFromContext(context);
        if (nessieVersion.isEmpty()) {
            return null;
        }
        Version version = nessieVersion.get();
        AnnotatedFields.populateAnnotatedFields(context, instance, NessieVersion.class, a -> true, f -> version);
        return version;
    }

    static Optional<Version> nessieVersionFromContext(ExtensionContext context) {
        return AbstractMultiVersionExtension.nessieVersionFromContext(UniqueId.parse((String)context.getUniqueId()));
    }

    static Optional<Version> nessieVersionFromContext(UniqueId uniqueId) {
        return uniqueId.getSegments().stream().filter(s -> NESSIE_VERSION_SEGMENT_TYPE.equals(s.getType())).map(UniqueId.Segment::getValue).map(Version::parseVersion).findFirst();
    }
}

