/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.api.NessieAPI;
import org.projectnessie.tools.compatibility.api.NessieApiBuilderProperty;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.ClientKey;
import org.projectnessie.tools.compatibility.internal.CurrentNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.OldNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.TranslatingVersionNessieApi;
import org.projectnessie.tools.compatibility.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNessieApiHolder
implements ExtensionContext.Store.CloseableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNessieApiHolder.class);
    protected final ClientKey clientKey;

    static Object apiInstanceForField(ExtensionContext context, Field field, Version version, Function<ExtensionContext, NessieServer> nessieServerSupplier) {
        ClientKey clientKey = AbstractNessieApiHolder.createClientKey(context, field, version, nessieServerSupplier);
        if (version.equals(Version.CURRENT)) {
            return ((CurrentNessieApiHolder)Util.extensionStore(context).getOrComputeIfAbsent((Object)clientKey, CurrentNessieApiHolder::new, CurrentNessieApiHolder.class)).getApiInstance();
        }
        return ((OldNessieApiHolder)context.getStore(Util.NAMESPACE).getOrComputeIfAbsent((Object)clientKey, k -> new OldNessieApiHolder(context, (ClientKey)k), OldNessieApiHolder.class)).getApiInstance();
    }

    private static ClientKey createClientKey(ExtensionContext context, Field field, Version version, Function<ExtensionContext, NessieServer> nessieServerSupplier) {
        NessieAPI nessieAPI = field.getAnnotation(NessieAPI.class);
        Class<?> apiType = field.getType();
        Map<String, String> configs = AbstractNessieApiHolder.buildApiBuilderConfig(context, field, apiType, nessieServerSupplier);
        return new ClientKey(version, nessieAPI.builderClassName(), apiType, configs);
    }

    private static Map<String, String> buildApiBuilderConfig(ExtensionContext context, Field field, Class<? extends NessieApi> apiType, Function<ExtensionContext, NessieServer> nessieServerSupplier) {
        HashMap<String, String> configs = new HashMap<String, String>();
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)field, NessieApiBuilderProperty.class).forEach(prop -> configs.put(prop.name(), prop.value()));
        NessieServer nessieServer = nessieServerSupplier.apply(context);
        URI uri = nessieServer.getUri(apiType);
        if (uri != null) {
            configs.put("nessie.uri", uri.toString());
        }
        return configs;
    }

    protected AbstractNessieApiHolder(ClientKey clientKey) {
        this.clientKey = clientKey;
    }

    public void close() {
        LOGGER.info("Closing Nessie client for version {}", (Object)this.clientKey.getVersion());
        NessieApi api = this.getApiInstance();
        if (api != null) {
            api.close();
        }
    }

    public abstract NessieApi getApiInstance();

    protected static AutoCloseable createNessieClient(ClassLoader classLoader, ClientKey clientKey) {
        try {
            Object apiInstance;
            Function<String, String> getCfg;
            block11: {
                Class<?> targetClass;
                Object builderInstance;
                Class<?> nessieClientBuilderClass = classLoader.loadClass("org.projectnessie.client.NessieClientBuilder");
                String builderClass = clientKey.getBuilderClass();
                if ("_DEFAULT_BUILDER_CLASS_NAME_".equals(builderClass)) {
                    builderClass = null;
                }
                try {
                    Method createClientBuilderMethod = nessieClientBuilderClass.getDeclaredMethod("createClientBuilder", String.class, String.class);
                    builderInstance = createClientBuilderMethod.invoke(null, null, builderClass);
                }
                catch (NoSuchMethodException ignore) {
                    if (builderClass == null) {
                        builderClass = "org.projectnessie.client.http.HttpClientBuilder";
                    }
                    Class<?> builderClazz = classLoader.loadClass(builderClass);
                    builderInstance = builderClazz.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                }
                Method fromConfigMethod = builderInstance.getClass().getMethod("fromConfig", Function.class);
                getCfg = k -> {
                    String v = clientKey.getConfigs().get(k);
                    if (v != null) {
                        return v;
                    }
                    return System.getProperty(k);
                };
                builderInstance = fromConfigMethod.invoke(builderInstance, getCfg);
                try {
                    targetClass = classLoader.loadClass(clientKey.getType().getName());
                }
                catch (ClassNotFoundException e) {
                    Class<? extends NessieApi> declaredType = clientKey.getType();
                    return TranslatingVersionNessieApi.unsupportedApiInterfaceProxy(declaredType, clientKey.getVersion());
                }
                Method buildMethod = builderInstance.getClass().getMethod("build", Class.class);
                apiInstance = null;
                try {
                    apiInstance = buildMethod.invoke(builderInstance, targetClass);
                }
                catch (InvocationTargetException e) {
                    if (AbstractNessieApiHolder.isNessieApiCompatibilityException(e)) break block11;
                    throw e;
                }
            }
            LOGGER.info("Created Nessie client for version {} for {}", (Object)clientKey.getVersion(), (Object)getCfg.apply("nessie.uri"));
            return (AutoCloseable)apiInstance;
        }
        catch (InvocationTargetException e) {
            throw Util.throwUnchecked(e.getTargetException());
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
    }

    private static boolean isNessieApiCompatibilityException(InvocationTargetException e) {
        return e.getCause() != null && e.getCause().getClass().getSimpleName().equals("NessieApiCompatibilityException");
    }
}

