/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.tools.compatibility.api.NessieAPI;
import org.projectnessie.tools.compatibility.api.TargetVersion;

final class AnnotatedFields {
    private AnnotatedFields() {
    }

    static void populateNessieApiFields(ExtensionContext context, Object instance, TargetVersion targetVersion, Function<Field, Object> fieldValue) {
        AnnotatedFields.populateAnnotatedFields(context, instance, NessieAPI.class, a -> a.targetVersion() == targetVersion, fieldValue);
    }

    static <A extends Annotation> void populateAnnotatedFields(ExtensionContext context, Object instance, Class<A> annotationType, Predicate<A> annotationFilter, Function<Field, Object> fieldValue) {
        Class clazz = context.getRequiredTestClass();
        boolean isStatic = instance == null;
        Predicate<Field> staticPredicate = field -> isStatic == ReflectionUtils.isStatic((Member)field);
        Predicate<Field> annotationPredicate = field -> AnnotationUtils.findAnnotation((AnnotatedElement)field, (Class)annotationType).map(annotationFilter::test).orElse(true);
        AnnotationUtils.findAnnotatedFields((Class)clazz, annotationType, staticPredicate.and(annotationPredicate)).forEach(f -> AnnotatedFields.setField(f, instance, fieldValue.apply((Field)f)));
    }

    private static void setField(Field field, Object instance, Object value) {
        field.setAccessible(true);
        try {
            if (Modifier.isStatic(field.getModifiers()) ? instance != null : instance == null) {
                return;
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

