/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class Configurations {
    public static final String CONFIG_NAME_PREFIX = "nessie.store.";
    private static final Pattern TO_PROPERTY_NAME_PATTERN = Pattern.compile("([a-z])([A-Z]+)");

    private Configurations() {
    }

    static <T> void backendConfigBuilderApply(Class<?> builderType, T config, Function<String, String> property) {
        List<Method> methods = Arrays.stream(config.getClass().getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> builderType.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 1).filter(m -> property.apply(Configurations.toPropertyName(m.getName())) != null).collect(Collectors.toList());
        Configurations.configApply(config, m -> (String)property.apply(Configurations.toPropertyName(m.getName())), methods);
    }

    private static <T> void configApply(T config, Function<Method, String> property, List<Method> methods) {
        try {
            for (Method m : methods) {
                Class<?> type = m.getParameterTypes()[0];
                String value = property.apply(m);
                if (type == String.class) {
                    config = m.invoke(config, value);
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    config = m.invoke(config, Integer.parseInt(value));
                    continue;
                }
                if (type == Long.class || type == Long.TYPE) {
                    config = m.invoke(config, Long.parseLong(value));
                    continue;
                }
                if (type == Float.class || type == Float.TYPE) {
                    config = m.invoke(config, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (type == Double.class || type == Double.TYPE) {
                    config = m.invoke(config, Double.parseDouble(value));
                    continue;
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    config = m.invoke(config, Boolean.parseBoolean(value));
                    continue;
                }
                if (type == Path.class) {
                    config = m.invoke(config, Paths.get(value, new String[0]));
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert the string value for " + m.getName() + " to " + type.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toPropertyName(String name) {
        return CONFIG_NAME_PREFIX + TO_PROPERTY_NAME_PATTERN.matcher(name).replaceAll("$1.$2").toLowerCase(Locale.ROOT);
    }
}

