/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.net.URI;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.internal.Configurations;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;
import org.projectnessie.tools.compatibility.jersey.JerseyServer;
import org.projectnessie.tools.compatibility.jersey.ServerConfigExtension;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.BackendFactory;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.common.persist.PersistLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CurrentNessieServer
implements NessieServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentNessieServer.class);
    private final ServerKey serverKey;
    private final JerseyServer jersey;
    private final BooleanSupplier initializeRepository;
    private Persist persist;
    private AutoCloseable connectionProvider;

    static CurrentNessieServer currentNessieServer(ExtensionContext extensionContext, ServerKey serverKey, BooleanSupplier initializeRepository, Consumer<Object> backendConfigConsumer) {
        return (CurrentNessieServer)Util.extensionStore(extensionContext).getOrComputeIfAbsent((Object)serverKey, k -> new CurrentNessieServer(serverKey, initializeRepository, backendConfigConsumer), CurrentNessieServer.class);
    }

    @Override
    public URI getUri(Class<? extends NessieApi> apiType) {
        return Util.resolveNessieUri(this.jersey.getUri(), this.serverKey.getVersion(), apiType);
    }

    public void close() throws Throwable {
        try {
            if (this.jersey != null) {
                this.jersey.close();
            }
        }
        finally {
            if (this.connectionProvider != null) {
                LOGGER.info("Closing connection provider for current Nessie version");
                this.connectionProvider.close();
            }
        }
    }

    private CurrentNessieServer(ServerKey serverKey, BooleanSupplier initializeRepository, Consumer<Object> backendConfigConsumer) {
        try {
            this.serverKey = serverKey;
            this.initializeRepository = initializeRepository;
            this.jersey = new JerseyServer(() -> this.getOrCreatePersist(backendConfigConsumer));
            LOGGER.info("Nessie Server started at {}", (Object)this.jersey.getUri());
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
    }

    private synchronized Persist getOrCreatePersist(Consumer<Object> backendConfigConsumer) {
        if (this.persist == null) {
            LOGGER.info("Creating Persist current Nessie version");
            Backend backend = CurrentNessieServer.createBackend(this.serverKey.getStorageName(), this.serverKey.getConfig(), backendConfigConsumer);
            this.connectionProvider = backend;
            this.persist = CurrentNessieServer.createPersist(backend, this.initializeRepository.getAsBoolean(), this.serverKey.getConfig());
        }
        return this.persist;
    }

    private static Persist createPersist(Backend backend, boolean initializeRepository, Map<String, String> configuration) {
        PersistFactory persistFactory = backend.createFactory();
        StoreConfig.Adjustable storeConfig = StoreConfig.Adjustable.empty();
        storeConfig = storeConfig.fromFunction(p -> (String)configuration.get("nessie.store." + p));
        Persist persist = persistFactory.newPersist((StoreConfig)storeConfig);
        if (initializeRepository) {
            persist.erase();
            Logics.repositoryLogic((Persist)persist).initialize(ServerConfigExtension.SERVER_CONFIG.getDefaultBranch());
        }
        return persist;
    }

    private static <CONFIG> Backend createBackend(String backendName, Map<String, String> config, Consumer<Object> backendConfigConsumer) {
        Object backendConfig;
        BackendFactory factory = PersistLoader.findFactoryByName((String)backendName);
        try {
            Object backendConfigBuilder = Class.forName(factory.getClass().getName().replace("BackendFactory", "BackendConfig")).getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
            Configurations.backendConfigBuilderApply(backendConfigBuilder.getClass(), backendConfigBuilder, config::get);
            backendConfigConsumer.accept(backendConfigBuilder);
            backendConfig = backendConfigBuilder.getClass().getMethod("build", new Class[0]).invoke(backendConfigBuilder, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Backend backend = factory.buildBackend(backendConfig);
        backend.setupSchema();
        return backend;
    }
}

